<?php
require __DIR__ . '/_guard.php';
$pdo = db();

$msg = '';
$err = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'return') {
  $bookId = (int)($_POST['book_id'] ?? 0);
  if ($bookId > 0) {
    $st = $pdo->prepare("UPDATE loans SET returned_at = date('now') WHERE book_id=? AND returned_at IS NULL");
    $st->execute([$bookId]);
    $msg = $st->rowCount() ? 'Rückgabe gespeichert (Datum heute).': 'Keine aktive Ausleihe gefunden.';
  }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'manual_loan') {
  $bookId = (int)($_POST['book_id'] ?? 0);
  $userName = trim((string)($_POST['user_name'] ?? ''));
  if ($bookId <= 0 || $userName === '') {
    $err = 'Bitte Buch und Name angeben.';
  } else {
    try {
      $stmt = $pdo->prepare("SELECT id FROM users WHERE lower(name)=lower(?) LIMIT 1");
      $stmt->execute([$userName]);
      $u = $stmt->fetch();
      if (!$u) {
        $insU = $pdo->prepare("INSERT INTO users (name, role) VALUES (?, 'member')");
        $insU->execute([$userName]);
        $uid = (int)$pdo->lastInsertId();
      } else {
        $uid = (int)$u['id'];
      }

      $insL = $pdo->prepare("INSERT INTO loans (book_id, user_id, loaned_at) VALUES (?, ?, datetime('now'))");
      $insL->execute([$bookId, $uid]);
      $msg = 'Ausleihe eingetragen.';
    } catch (PDOException $e) {
      $err = 'Buch ist bereits ausgeliehen.';
    }
  }
}

$active = $pdo->query("
  SELECT l.id AS loan_id, l.book_id, l.user_id, l.loaned_at,
         b.title, u.name AS user_name
  FROM loans l
  JOIN books b ON b.id=l.book_id
  JOIN users u ON u.id=l.user_id
  WHERE l.returned_at IS NULL
  ORDER BY l.loaned_at DESC
")->fetchAll();

$booksFree = $pdo->query("
  SELECT b.id, b.title
  FROM books b
  LEFT JOIN loans l ON l.book_id=b.id AND l.returned_at IS NULL
  WHERE l.id IS NULL
  ORDER BY b.title
")->fetchAll();

require __DIR__ . '/_layout_top.php';
?>

<h1 class="h4 mb-3">Ausleihen</h1>

<?php if ($msg): ?><div class="alert alert-success"><?= htmlspecialchars($msg) ?></div><?php endif; ?>
<?php if ($err): ?><div class="alert alert-danger"><?= htmlspecialchars($err) ?></div><?php endif; ?>

<div class="card shadow-sm mb-4">
  <div class="card-body">
    <h2 class="h6 mb-3">Manuell ausleihen (Admin)</h2>
    <form method="post" class="row g-3">
      <input type="hidden" name="action" value="manual_loan">
      <div class="col-md-6">
        <label class="form-label">Freies Buch</label>
        <select class="form-select" name="book_id" required>
          <option value="">Bitte wählen…</option>
          <?php foreach ($booksFree as $b): ?>
            <option value="<?= (int)$b['id'] ?>"><?= htmlspecialchars((string)$b['title']) ?> (ID <?= (int)$b['id'] ?>)</option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">Name (Mitglied)</label>
        <input class="form-control" name="user_name" required>
      </div>
      <div class="col-12">
        <button class="btn btn-primary">Eintragen</button>
      </div>
    </form>
  </div>
</div>

<div class="card shadow-sm">
  <div class="card-body">
    <h2 class="h6 mb-3">Aktive Ausleihen</h2>
    <div class="table-responsive">
      <table class="table table-sm align-middle">
        <thead>
          <tr>
            <th>Buch</th><th>Ausgeliehen von</th><th>Seit</th><th></th>
          </tr>
        </thead>
        <tbody>
        <?php if (!$active): ?>
          <tr><td colspan="4" class="text-muted">Keine aktiven Ausleihen.</td></tr>
        <?php endif; ?>
        <?php foreach ($active as $l): ?>
          <tr>
            <td><?= htmlspecialchars((string)$l['title']) ?><div class="text-muted small">ID <?= (int)$l['book_id'] ?></div></td>
            <td><?= htmlspecialchars((string)$l['user_name']) ?></td>
            <td><?= htmlspecialchars((string)$l['loaned_at']) ?></td>
            <td class="text-end">
              <form method="post" style="display:inline">
                <input type="hidden" name="action" value="return">
                <input type="hidden" name="book_id" value="<?= (int)$l['book_id'] ?>">
                <button class="btn btn-sm btn-outline-success" onclick="return confirm('Rückgabe-Datum (heute) setzen?')">Zurückgeben</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php require __DIR__ . '/_layout_bottom.php'; ?>
