<?php
declare(strict_types=1);
require __DIR__ . '/db.php';
require_installed();
require_admin();

$data = read_json_body();
$bookId = (int)($data['book_id'] ?? 0);
$userName = trim((string)($data['user_name'] ?? ''));
if ($bookId <= 0 || $userName === '') json_response(['ok' => false, 'error' => 'book_id oder user_name fehlt.'], 400);

try {
  $pdo = db();
  $stmt = $pdo->prepare("SELECT id FROM users WHERE lower(name)=lower(?) LIMIT 1");
  $stmt->execute([$userName]);
  $u = $stmt->fetch();
  if (!$u) {
    $insU = $pdo->prepare("INSERT INTO users (name, role) VALUES (?, 'member')");
    $insU->execute([$userName]);
    $uid = (int)$pdo->lastInsertId();
  } else {
    $uid = (int)$u['id'];
  }

  $insL = $pdo->prepare("INSERT INTO loans (book_id, user_id, loaned_at) VALUES (?, ?, datetime('now'))");
  $insL->execute([$bookId, $uid]);

  json_response(['ok' => true]);
} catch (PDOException $e) {
  if (str_contains($e->getMessage(), 'UNIQUE') || str_contains($e->getMessage(), 'constraint')) {
    json_response(['ok' => false, 'error' => 'Buch ist bereits ausgeliehen.'], 409);
  }
  json_response(['ok' => false, 'error' => $e->getMessage()], 500);
} catch (Throwable $e) {
  json_response(['ok' => false, 'error' => $e->getMessage()], 500);
}
