<?php
declare(strict_types=1);
require __DIR__ . '/db.php';
require_installed();

try {
  $pdo = db();
  $sql = "
    SELECT b.id, b.title, b.author, b.isbn, b.note, b.image, b.created_at,
           CASE WHEN l.id IS NULL THEN 1 ELSE 0 END AS available,
           u.name AS loaned_to,
           l.loaned_at
    FROM books b
    LEFT JOIN loans l ON l.book_id = b.id AND l.returned_at IS NULL
    LEFT JOIN users u ON u.id = l.user_id
    ORDER BY b.id DESC
  ";
  $rows = $pdo->query($sql)->fetchAll();

  // add computed image_url
  $base = base_url();
  foreach ($rows as &$r) {
    if (!empty($r['image'])) {
      $r['image_url'] = $base . '/uploads/books/' . $r['image'];
    } else {
      $r['image_url'] = $base . '/assets/no-cover.svg';
    }
  }
  unset($r);

  json_response(['ok' => true, 'books' => $rows]);
} catch (Throwable $e) {
  json_response(['ok' => false, 'error' => $e->getMessage()], 500);
}
