<?php
declare(strict_types=1);

$cfgFile = __DIR__ . '/../config.php';
if (file_exists($cfgFile)) {
  die('Installer ist gesperrt (config.php existiert). Bitte /install löschen oder config.php entfernen, falls Neuinstallation gewünscht.');
}

$phpOk = version_compare(PHP_VERSION, '8.0.0', '>=');
$pdoOk = extension_loaded('pdo_sqlite');
$dataDir = __DIR__ . '/../data';
$uploadsDir = __DIR__ . '/../uploads/books';
$dataWritable = is_dir($dataDir) && is_writable($dataDir);
$uploadsWritable = is_dir($uploadsDir) && is_writable($uploadsDir);
?>
<!doctype html>
<html lang="de">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Installer – Bibliothek</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5" style="max-width: 900px;">
  <div class="card shadow-sm">
    <div class="card-body">
      <h1 class="h4 mb-3">Installer – Bibliotheks-Ausleihe</h1>

      <div class="row g-3 mb-4">
        <div class="col-md-3">
          <div class="p-3 border rounded bg-white">
            <div class="fw-semibold">PHP ≥ 8.0</div>
            <div class="<?= $phpOk ? 'text-success' : 'text-danger' ?>"><?= htmlspecialchars(PHP_VERSION) ?></div>
          </div>
        </div>
        <div class="col-md-3">
          <div class="p-3 border rounded bg-white">
            <div class="fw-semibold">PDO SQLite</div>
            <div class="<?= $pdoOk ? 'text-success' : 'text-danger' ?>"><?= $pdoOk ? 'aktiv' : 'fehlt' ?></div>
          </div>
        </div>
        <div class="col-md-3">
          <div class="p-3 border rounded bg-white">
            <div class="fw-semibold">/data beschreibbar</div>
            <div class="<?= $dataWritable ? 'text-success' : 'text-danger' ?>"><?= $dataWritable ? 'ja' : 'nein' ?></div>
          </div>
        </div>
        <div class="col-md-3">
          <div class="p-3 border rounded bg-white">
            <div class="fw-semibold">/uploads/books beschreibbar</div>
            <div class="<?= $uploadsWritable ? 'text-success' : 'text-danger' ?>"><?= $uploadsWritable ? 'ja' : 'nein' ?></div>
          </div>
        </div>
      </div>

      <?php if (!$phpOk || !$pdoOk || !$dataWritable || !$uploadsWritable): ?>
        <div class="alert alert-danger">
          Systemcheck fehlgeschlagen. Bitte Voraussetzungen erfüllen (PHP/SQLite/Schreibrechte).
        </div>
      <?php else: ?>
        <form method="post" action="install.php" class="row g-3">
          <div class="col-md-6">
            <label class="form-label">App-Name</label>
            <input class="form-control" name="app_name" value="Bibliothek" required>
          </div>
          <div class="col-md-6">
            <label class="form-label">Admin-Name</label>
            <input class="form-control" name="admin_name" value="Admin" required>
          </div>
          <div class="col-md-6">
            <label class="form-label">Admin-PIN (3–12 Ziffern)</label>
            <input class="form-control" name="admin_pin" required inputmode="numeric" pattern="[0-9]{3,12}">
          </div>
          <div class="col-md-6">
            <label class="form-label">PIN wiederholen</label>
            <input class="form-control" name="admin_pin2" required inputmode="numeric" pattern="[0-9]{3,12}">
          </div>

          <div class="col-12">
            <button class="btn btn-primary">Installieren</button>
          </div>
        </form>

        <div class="text-muted small mt-3">
          Tipp: Nach der Installation bitte den Ordner <code>/install</code> löschen.
        </div>
      <?php endif; ?>
    </div>
  </div>
</div>
</body>
</html>
