<?php
require __DIR__ . '/_guard.php';
$pdo = db();

$msg = '';
$err = '';

$uploadDir = realpath(__DIR__ . '/../uploads/books');
if ($uploadDir === false) {
  $err = 'Upload-Ordner /uploads/books fehlt.';
}

function safe_ext(string $mime, string $name): ?string {
  $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
  $map = [
    'image/jpeg' => 'jpg',
    'image/png'  => 'png',
    'image/webp' => 'webp',
  ];
  if (isset($map[$mime])) return $map[$mime];
  // fallback: accept by extension only if allowed
  if (in_array($ext, ['jpg','jpeg','png','webp'], true)) return ($ext === 'jpeg' ? 'jpg' : $ext);
  return null;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'add') {
  $title = trim((string)($_POST['title'] ?? ''));
  $author = trim((string)($_POST['author'] ?? ''));
  $isbn = trim((string)($_POST['isbn'] ?? ''));
  $note = trim((string)($_POST['note'] ?? ''));

  if ($title === '') {
    $err = 'Titel fehlt.';
  } else {
    $imageName = null;

    if (!empty($_FILES['image']['tmp_name'])) {
      if (!empty($_FILES['image']['error']) && $_FILES['image']['error'] !== UPLOAD_ERR_OK) {
        $err = 'Bild-Upload fehlgeschlagen (Fehlercode ' . (int)$_FILES['image']['error'] . ').';
      } else {
        $size = (int)($_FILES['image']['size'] ?? 0);
        if ($size > 5 * 1024 * 1024) {
          $err = 'Bild ist zu groß (max. 5 MB).';
        } else {
          $tmp = (string)$_FILES['image']['tmp_name'];
          $mime = (string)@mime_content_type($tmp);
          $ext = safe_ext($mime, (string)$_FILES['image']['name']);
          if (!$ext) {
            $err = 'Nur JPG, PNG oder WEBP erlaubt.';
          } else {
            $imageName = 'book_' . bin2hex(random_bytes(8)) . '.' . $ext;
            $dest = $uploadDir . DIRECTORY_SEPARATOR . $imageName;
            if (!move_uploaded_file($tmp, $dest)) {
              $err = 'Konnte Bild nicht speichern.';
              $imageName = null;
            }
          }
        }
      }
    }

    if ($err === '') {
      $st = $pdo->prepare("INSERT INTO books (title, author, isbn, note, image, created_at) VALUES (?, ?, ?, ?, ?, datetime('now'))");
      $st->execute([$title, $author, $isbn, $note, $imageName]);
      $msg = 'Buch gespeichert.';
    }
  }
}

if (($_GET['del'] ?? '') !== '') {
  $id = (int)$_GET['del'];
  if ($id > 0) {
    // delete file if exists
    $st = $pdo->prepare("SELECT image FROM books WHERE id=?");
    $st->execute([$id]);
    $row = $st->fetch();
    if ($row && !empty($row['image'])) {
      $p = __DIR__ . '/../uploads/books/' . $row['image'];
      if (is_file($p)) @unlink($p);
    }
    $st = $pdo->prepare("DELETE FROM books WHERE id=?");
    $st->execute([$id]);
    $msg = 'Buch gelöscht.';
  }
}

$base = base_url();
$books = $pdo->query("SELECT b.*,
  CASE WHEN l.id IS NULL THEN 1 ELSE 0 END AS available
  FROM books b
  LEFT JOIN loans l ON l.book_id=b.id AND l.returned_at IS NULL
  ORDER BY b.id DESC")->fetchAll();

require __DIR__ . '/_layout_top.php';
?>

<h1 class="h4 mb-3">Bücher</h1>

<?php if ($msg): ?><div class="alert alert-success"><?= htmlspecialchars($msg) ?></div><?php endif; ?>
<?php if ($err): ?><div class="alert alert-danger"><?= htmlspecialchars($err) ?></div><?php endif; ?>

<div class="card shadow-sm mb-4">
  <div class="card-body">
    <h2 class="h6 mb-3">Neues Buch anlegen</h2>
    <form method="post" class="row g-3" enctype="multipart/form-data">
      <input type="hidden" name="action" value="add">
      <div class="col-md-6">
        <label class="form-label">Titel *</label>
        <input class="form-control" name="title" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">Autor</label>
        <input class="form-control" name="author">
      </div>
      <div class="col-md-4">
        <label class="form-label">ISBN</label>
        <input class="form-control" name="isbn">
      </div>
      <div class="col-md-8">
        <label class="form-label">Beschreibung</label>
        <input class="form-control" name="note" placeholder="Kurzbeschreibung / Notiz">
      </div>
      <div class="col-md-6">
        <label class="form-label">Buchbild (JPG/PNG/WEBP, max. 5 MB)</label>
        <input class="form-control" type="file" name="image" accept="image/jpeg,image/png,image/webp">
      </div>
      <div class="col-12">
        <button class="btn btn-primary">Speichern</button>
      </div>
    </form>
  </div>
</div>

<div class="card shadow-sm">
  <div class="card-body">
    <h2 class="h6 mb-3">Liste</h2>
    <div class="table-responsive">
      <table class="table table-sm align-middle">
        <thead>
          <tr>
            <th></th><th>ID</th><th>Titel</th><th>Autor</th><th>ISBN</th><th>Status</th><th></th>
          </tr>
        </thead>
        <tbody>
        <?php foreach ($books as $b): 
          $img = !empty($b['image']) ? ($base . '/uploads/books/' . $b['image']) : ($base . '/assets/no-cover.svg');
        ?>
          <tr>
            <td><img class="cover-thumb" src="<?= htmlspecialchars($img) ?>" alt=""></td>
            <td><?= (int)$b['id'] ?></td>
            <td><?= htmlspecialchars((string)$b['title']) ?></td>
            <td><?= htmlspecialchars((string)($b['author'] ?? '')) ?></td>
            <td><?= htmlspecialchars((string)($b['isbn'] ?? '')) ?></td>
            <td>
              <?php if ((int)$b['available'] === 1): ?>
                <span class="badge text-bg-success">frei</span>
              <?php else: ?>
                <span class="badge text-bg-warning">ausgeliehen</span>
              <?php endif; ?>
            </td>
            <td class="text-end">
              <a class="btn btn-sm btn-outline-danger" href="?del=<?= (int)$b['id'] ?>" onclick="return confirm('Buch wirklich löschen?')">Löschen</a>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php require __DIR__ . '/_layout_bottom.php'; ?>
