<?php
declare(strict_types=1);
require __DIR__ . '/../api/db.php';
require_installed();
ensure_session();

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name = trim((string)($_POST['name'] ?? ''));
  $pin  = (string)($_POST['pin'] ?? '');

  if ($name === '' || $pin === '') {
    $error = 'Bitte Name und PIN eingeben.';
  } else {
    try {
      $pdo = db();
      $stmt = $pdo->prepare("SELECT id, name, role, pin_hash FROM users WHERE lower(name)=lower(?) AND role='admin' LIMIT 1");
      $stmt->execute([$name]);
      $u = $stmt->fetch();
      if ($u && !empty($u['pin_hash']) && password_verify($pin, (string)$u['pin_hash'])) {
        $_SESSION['user_id'] = (int)$u['id'];
        $_SESSION['user_name'] = (string)$u['name'];
        $_SESSION['role'] = 'admin';
        header('Location: dashboard.php');
        exit;
      } else {
        $error = 'Login fehlgeschlagen.';
      }
    } catch (Throwable $e) {
      $error = $e->getMessage();
    }
  }
}

$cfg = app_config();
$appName = htmlspecialchars((string)($cfg['app_name'] ?? 'Bibliothek'), ENT_QUOTES, 'UTF-8');
?>
<!doctype html>
<html lang="de">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= $appName ?> – Admin Login</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5" style="max-width:520px;">
  <div class="card shadow-sm">
    <div class="card-body">
      <h1 class="h4 mb-3"><?= $appName ?> – Admin Login</h1>
      <?php if ($error): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8') ?></div>
      <?php endif; ?>
      <form method="post" autocomplete="off">
        <div class="mb-3">
          <label class="form-label">Admin-Name</label>
          <input class="form-control" name="name" required>
        </div>
        <div class="mb-3">
          <label class="form-label">PIN</label>
          <input class="form-control" name="pin" required inputmode="numeric" pattern="[0-9]{3,12}">
        </div>
        <button class="btn btn-dark w-100">Einloggen</button>
      </form>
      <div class="text-muted small mt-3">
        Frontend-Ausleihe: <code>/mobirise/widget.php</code>
      </div>
    </div>
  </div>
</div>
</body>
</html>
