<?php
declare(strict_types=1);

require __DIR__ . '/db.php';
require_installed();

try {
    $pdo = db();

    $sql = "
        SELECT
            b.id,
            b.title,
            b.author,
            b.isbn,
            b.note,
            b.image,
            b.created_at,
            CASE WHEN l.id IS NULL THEN 1 ELSE 0 END AS available,
            u.name AS loaned_to,
            l.loaned_at
        FROM books b
        LEFT JOIN loans l ON l.book_id = b.id AND l.returned_at IS NULL
        LEFT JOIN users u ON u.id = l.user_id
        ORDER BY b.id DESC
    ";

    $books = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);

    // 🔑 robuster Web-Basispfad (funktioniert überall)
    $script  = $_SERVER['SCRIPT_NAME'] ?? '';
    $baseWeb = rtrim(dirname(dirname($script)), '/');

    foreach ($books as &$b) {
        if (!empty($b['image'])) {
            $b['image_url'] = $baseWeb . '/uploads/books/' . $b['image'];
        } else {
            $b['image_url'] = $baseWeb . '/assets/no-cover.svg';
        }
    }
    unset($b);

    json_response([
        'ok'    => true,
        'books' => $books
    ]);

} catch (Throwable $e) {
    json_response([
        'ok'    => false,
        'error' => $e->getMessage()
    ], 500);
}
