<?php
declare(strict_types=1);
require __DIR__ . '/db.php';
require_installed();
$u = require_login();

$data = read_json_body();
$bookId = (int)($data['book_id'] ?? 0);
if ($bookId <= 0) json_response(['ok' => false, 'error' => 'book_id fehlt.'], 400);

try {
  $pdo = db();
  $b = $pdo->prepare("SELECT id FROM books WHERE id=?");
  $b->execute([$bookId]);
  if (!$b->fetch()) json_response(['ok' => false, 'error' => 'Buch nicht gefunden.'], 404);

  $ins = $pdo->prepare("INSERT INTO loans (book_id, user_id, loaned_at) VALUES (?, ?, datetime('now'))");
  $ins->execute([$bookId, $u['id']]);

  json_response(['ok' => true, 'message' => 'Ausleihe gespeichert.']);
} catch (PDOException $e) {
  if (str_contains($e->getMessage(), 'UNIQUE') || str_contains($e->getMessage(), 'constraint')) {
    json_response(['ok' => false, 'error' => 'Dieses Buch ist aktuell bereits ausgeliehen.'], 409);
  }
  json_response(['ok' => false, 'error' => $e->getMessage()], 500);
} catch (Throwable $e) {
  json_response(['ok' => false, 'error' => $e->getMessage()], 500);
}
