<?php
session_start();

// PHP-Limits für Upload erhöhen
ini_set('upload_max_filesize', '10M');
ini_set('post_max_size', '50M');
ini_set('max_file_uploads', '20');
ini_set('max_execution_time', '300');
ini_set('memory_limit', '512M');

// Konfiguration
define('UPLOAD_DIR', 'uploads/');
// define('THUMB_DIR', 'uploads/thumbs/'); // Änderung: Diesen Pfad benötigen wir nicht mehr
define('ADMIN_PASSWORD', 'Rehmuehle1'); // Ändern Sie dieses Passwort!
define('MAX_FILE_SIZE', 10 * 1024 * 1024); // 10MB
define('ALLOWED_TYPES', ['jpg', 'jpeg', 'png', 'gif', 'webp']);
define('IMAGES_PER_PAGE', 12); // Anzahl der Bilder pro Seite

// Verzeichnisse erstellen falls sie nicht existieren
if (!file_exists(UPLOAD_DIR)) {
    mkdir(UPLOAD_DIR, 0755, true);
}
// if (!file_exists(THUMB_DIR)) { // Änderung: Das Erstellen des Thumb-Verzeichnisses entfällt
//    mkdir(THUMB_DIR, 0755, true);
// }

// Funktionen
function isLoggedIn() {
    return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
}

function getImageFiles() {
    $images = [];
    if (!is_dir(UPLOAD_DIR)) {
        return $images;
    }
    
    $files = glob(UPLOAD_DIR . '*.{jpg,jpeg,png,gif,webp}', GLOB_BRACE);
    if ($files === false) {
        return $images;
    }
    
    foreach ($files as $file) {
        if (is_file($file)) {
            $images[] = [
                'filename' => basename($file),
                'path' => $file,
                'size' => filesize($file),
                'modified' => filemtime($file)
            ];
        }
    }
    usort($images, function($a, $b) {
        return $b['modified'] - $a['modified'];
    });
    return $images;
}

// Änderung: Die Funktion zum Erstellen von Thumbnails ist nicht mehr notwendig und wird entfernt
// function createThumbnail(...) { ... }

// AJAX Upload Handler
if (isset($_POST['ajax_upload']) && isLoggedIn()) {
    header('Content-Type: application/json');
    
    $response = ['success' => false, 'message' => '', 'filename' => ''];
    
    try {
        if (!isset($_FILES['image'])) {
            throw new Exception('Keine Datei empfangen');
        }
        
        $file = $_FILES['image'];
        
        if ($file['error'] !== UPLOAD_ERR_OK) {
            $errorMessages = [
                UPLOAD_ERR_INI_SIZE => 'Datei überschreitet Server-Limit',
                UPLOAD_ERR_FORM_SIZE => 'Datei zu groß',
                UPLOAD_ERR_PARTIAL => 'Upload unvollständig',
                UPLOAD_ERR_NO_FILE => 'Keine Datei ausgewählt',
                UPLOAD_ERR_NO_TMP_DIR => 'Temporärer Ordner fehlt',
                UPLOAD_ERR_CANT_WRITE => 'Schreibfehler',
                UPLOAD_ERR_EXTENSION => 'Upload blockiert'
            ];
            
            throw new Exception($errorMessages[$file['error']] ?? 'Unbekannter Upload-Fehler');
        }
        
        if (empty($file['name']) || empty($file['tmp_name'])) {
            throw new Exception('Ungültige Datei-Informationen');
        }
        
        if (!is_uploaded_file($file['tmp_name'])) {
            throw new Exception('Sicherheitsfehler: Datei wurde nicht korrekt hochgeladen');
        }
        
        $filename = $file['name'];
        $fileSize = $file['size'];
        $tmpName = $file['tmp_name'];
        $fileExt = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
        
        if (empty($fileExt)) {
            throw new Exception('Datei hat keine Erweiterung');
        }
        
        // MIME-Type prüfen
        $finfo = finfo_open(FILEINFO_MIME_TYPE);
        $mimeType = finfo_file($finfo, $tmpName);
        finfo_close($finfo);
        
        $allowedMimes = [
            'jpg' => 'image/jpeg',
            'jpeg' => 'image/jpeg', 
            'png' => 'image/png',
            'gif' => 'image/gif',
            'webp' => 'image/webp'
        ];
        
        if (!in_array($fileExt, ALLOWED_TYPES)) {
            throw new Exception('Dateityp nicht erlaubt');
        }
        
        if (!isset($allowedMimes[$fileExt]) || $mimeType !== $allowedMimes[$fileExt]) {
            throw new Exception('MIME-Type stimmt nicht mit Dateiendung überein');
        }
        
        if ($fileSize > MAX_FILE_SIZE) {
            throw new Exception('Datei zu groß (' . number_format($fileSize/1024/1024, 1) . 'MB)');
        }
        
        if ($fileSize <= 0) {
            throw new Exception('Datei ist leer');
        }
        
        $imageInfo = getimagesize($tmpName);
        if (!$imageInfo) {
            throw new Exception('Datei ist kein gültiges Bild');
        }
        
        // Sicheren Dateinamen erstellen
        $name = pathinfo($filename, PATHINFO_FILENAME);
        $safeName = preg_replace('/[^a-zA-Z0-9._-]/', '_', $name);
        $safeName = preg_replace('/_+/', '_', $safeName);
        $safeName = trim($safeName, '_');
        
        if (empty($safeName)) {
            $safeName = 'image_' . time();
        }
        
        $safeFilename = $safeName . '.' . $fileExt;
        
        // Datei existiert bereits? Nummer anhängen
        $counter = 1;
        $newFilename = $safeFilename;
        while (file_exists(UPLOAD_DIR . $newFilename)) {
            $newFilename = $safeName . '_' . $counter . '.' . $fileExt;
            $counter++;
            if ($counter > 1000) {
                throw new Exception('Zu viele Dateien mit ähnlichem Namen');
            }
        }
        
        $uploadPath = UPLOAD_DIR . $newFilename;
        // $thumbPath = THUMB_DIR . $newFilename; // Änderung: Thumb-Pfad ist nicht mehr notwendig
        
        if (!is_writable(UPLOAD_DIR)) {
            throw new Exception('Upload-Verzeichnis nicht beschreibbar');
        }
        
        if (!move_uploaded_file($tmpName, $uploadPath)) {
            throw new Exception('Fehler beim Verschieben der Datei');
        }
        
        // Änderung: Der Aufruf zur Thumbnail-Erstellung entfällt
        // $thumbnailCreated = false;
        // if (is_writable(THUMB_DIR)) {
        //     $thumbnailCreated = createThumbnail($uploadPath, $thumbPath);
        // }
        
        $response['success'] = true;
        // $response['message'] = 'Upload erfolgreich' . ($thumbnailCreated ? '' : ' (Thumbnail-Erstellung fehlgeschlagen)'); // Änderung: Die Meldung wird angepasst
        $response['message'] = 'Upload erfolgreich';
        $response['filename'] = $newFilename;
        
    } catch (Exception $e) {
        $response['message'] = $e->getMessage();
    }
    
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit;
}

// Login verarbeiten
if (isset($_POST['login'])) {
    if ($_POST['password'] === ADMIN_PASSWORD) {
        $_SESSION['admin_logged_in'] = true;
        header('Location: ' . $_SERVER['PHP_SELF']);
        exit;
    } else {
        $error = 'Falsches Passwort!';
    }
}

// Logout verarbeiten
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}

// Bild löschen
if (isset($_GET['delete']) && isLoggedIn()) {
    $filename = basename($_GET['delete']);
    $imagePath = UPLOAD_DIR . $filename;
    // $thumbPath = THUMB_DIR . $filename; // Änderung: Thumb-Pfad ist nicht mehr notwendig
    
    if (file_exists($imagePath)) {
        if (unlink($imagePath)) {
            // if (file_exists($thumbPath)) { // Änderung: Das Löschen des Thumbs entfällt
            //    unlink($thumbPath);
            // }
            $deleteSuccess = "Bild wurde gelöscht";
        } else {
            $deleteError = "Fehler beim Löschen der Datei";
        }
    } else {
        $deleteError = "Datei nicht gefunden";
    }
}

// Paginierung nur für Admins
$allImages = [];
$totalImages = 0;
$totalPages = 1;
$currentPage = 1;
$images = [];

if (isLoggedIn()) {
    $allImages = getImageFiles();
    $totalImages = count($allImages);
    $totalPages = ceil($totalImages / IMAGES_PER_PAGE);
    
    $currentPage = isset($_GET['page']) ? intval($_GET['page']) : 1;
    if ($currentPage < 1) {
        $currentPage = 1;
    } elseif ($currentPage > $totalPages && $totalPages > 0) {
        $currentPage = $totalPages;
    }
    
    $offset = ($currentPage - 1) * IMAGES_PER_PAGE;
    $images = array_slice($allImages, $offset, IMAGES_PER_PAGE);
}
?>

<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bildergalerie Admin</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    
    <style>
        body {
            background: #000000;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            min-height: 100vh;
        }
        
        .glass-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .gradient-text {
            background: linear-gradient(45deg, #667eea, #764ba2);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .upload-zone {
            border: 3px dashed #dee2e6;
            transition: all 0.3s ease;
            min-height: 200px;
            cursor: pointer;
        }
        
        .upload-zone.dragover {
            border-color: #667eea;
            background: rgba(102, 126, 234, 0.1);
        }
        
        .upload-queue-item {
            transition: all 0.3s ease;
        }
        
        .upload-queue-item.uploading {
            background: rgba(255, 193, 7, 0.1);
            border-left: 4px solid #ffc107;
        }
        
        .upload-queue-item.success {
            background: rgba(25, 135, 84, 0.1);
            border-left: 4px solid #198754;
        }
        
        .upload-queue-item.error {
            background: rgba(220, 53, 69, 0.1);
            border-left: 4px solid #dc3545;
        }
        
        .progress-container {
            height: 6px;
            background: rgba(0, 0, 0, 0.1);
            border-radius: 3px;
            overflow: hidden;
        }
        
        .progress-bar-custom {
            height: 100%;
            background: linear-gradient(45deg, #667eea, #764ba2);
            transition: width 0.3s ease;
        }
        
        .thumbnail-preview {
            width: 60px;
            height: 60px;
            object-fit: cover;
            border-radius: 8px;
        }
        
        .lightbox {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.9);
            z-index: 1000;
            cursor: pointer;
        }
        
        .lightbox img {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            max-width: 90%;
            max-height: 90%;
            border-radius: 10px;
        }
        
        .lightbox-close {
            position: absolute;
            top: 20px;
            right: 30px;
            color: white;
            font-size: 40px;
            cursor: pointer;
        }
        
        .login-section {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
    </style>
</head>
<body>

    <?php if (!isLoggedIn()): ?>
    
    <div class="login-section">
        <div class="col-md-6 col-lg-4">
            <div class="glass-card p-5 rounded-3">
                <div class="text-center mb-4">
                    <h1 class="gradient-text mb-3">
                        <i class="bi bi-images"></i> Bildergalerie
                    </h1>
                    <h3>Admin Login</h3>
                    <p class="text-muted">Melden Sie sich an, um die Bildergalerie zu verwalten</p>
                </div>
                <?php if (isset($error)): ?>
                <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
                <?php endif; ?>
                <form method="post">
                    <div class="mb-3">
                        <label for="password" class="form-label">Passwort:</label>
                        <input type="password" id="password" name="password" class="form-control form-control-lg" required>
                    </div>
                    <div class="d-grid">
                        <button type="submit" name="login" class="btn btn-primary btn-lg">
                            <i class="bi bi-box-arrow-in-right"></i> Anmelden
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php else: ?>
    <div class="row mb-4">
        <div class="col-12">
            <div class="glass-card p-4 rounded-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h1 class="gradient-text mb-2">
                            <i class="bi bi-images"></i> Bildergalerie Admin
                        </h1>
                        <p class="text-muted mb-0"><?php echo $totalImages; ?> Bilder in der Galerie</p>
                    </div>
                    <div>
                        <a href="?logout=1" class="btn btn-outline-danger">
                            <i class="bi bi-box-arrow-right"></i> Abmelden
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="row mb-4">
        <div class="col-12">
            <div class="glass-card p-4 rounded-3">
                <h3 class="mb-4">
                    <i class="bi bi-cloud-upload"></i> Upload-Bereich
                </h3>
                
                <?php if (isset($deleteSuccess)): ?>
                <div class="alert alert-success"><?php echo htmlspecialchars($deleteSuccess); ?></div>
                <?php endif; ?>
                <?php if (isset($deleteError)): ?>
                <div class="alert alert-danger"><?php echo htmlspecialchars($deleteError); ?></div>
                <?php endif; ?>
                
                <form id="upload-form" class="mb-4">
                    <div class="upload-zone text-center p-4 rounded-3 d-flex flex-column align-items-center justify-content-center">
                        <input type="file" id="file-input" name="images[]" multiple style="display: none;">
                        <i class="bi bi-cloud-arrow-up-fill display-4 text-primary mb-2"></i>
                        <p class="lead">Bilder hierher ziehen oder <a href="#" id="browse-btn" class="text-decoration-none">hier klicken</a></p>
                        <p class="text-muted mb-0">Max. Größe pro Bild: 10MB | Erlaubte Dateitypen: JPG, PNG, GIF, WEBP</p>
                    </div>
                    <div class="d-grid gap-2 mt-3">
                        <button id="upload-btn" type="submit" class="btn btn-primary btn-lg" disabled>
                            <i class="bi bi-upload"></i> Hochladen
                        </button>
                    </div>
                </form>

                <div id="upload-status" class="mb-3"></div>
                <div class="progress-container mb-2">
                    <div id="progressBar" class="progress-bar-custom" role="progressbar" style="width: 0%;" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
                <div class="d-flex justify-content-between text-muted">
                    <small id="totalProgressText">0 von 0</small>
                    <small id="uploadSpeed">0 Bilder/Sek</small>
                </div>
                
                <hr class="my-4">
                
                <h3 class="mb-4">
                    <i class="bi bi-list-ul"></i> Bilder verwalten
                </h3>
                
                <div id="image-list" class="row g-4">
                    <?php if (empty($images)): ?>
                    <div class="col-12">
                        <div class="alert alert-info text-center">
                            Keine Bilder in der Galerie gefunden.
                        </div>
                    </div>
                    <?php else: ?>
                        <?php foreach ($images as $image): ?>
                            <div class="col-6 col-sm-4 col-md-3 col-lg-2">
                                <div class="card bg-transparent border-0 h-100">
                                    <div class="position-relative">
                                        <img src="<?= htmlspecialchars(UPLOAD_DIR . $image['filename']) ?>" 
                                             class="img-fluid rounded-3 shadow-sm w-100" 
                                             alt="<?= htmlspecialchars($image['filename']) ?>"
                                             onclick="openLightbox('<?= htmlspecialchars(UPLOAD_DIR . $image['filename']) ?>')">
                                        <div class="position-absolute bottom-0 end-0 m-2">
                                            <a href="?delete=<?= urlencode($image['filename']) ?>" class="btn btn-sm btn-danger" onclick="return confirm('Sicher, dass Sie dieses Bild löschen möchten?');">
                                                <i class="bi bi-trash-fill"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>

                <?php if ($totalPages > 1): ?>
                    <nav aria-label="Seiten-Navigation" class="mt-4">
                        <ul class="pagination justify-content-center">
                            <li class="page-item <?= $currentPage <= 1 ? 'disabled' : '' ?>">
                                <a class="page-link" href="?page=<?= max(1, $currentPage - 1) ?>">Vorherige</a>
                            </li>
                            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                                <li class="page-item <?= $currentPage === $i ? 'active' : '' ?>">
                                    <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                                </li>
                            <?php endfor; ?>
                            <li class="page-item <?= $currentPage >= $totalPages ? 'disabled' : '' ?>">
                                <a class="page-link" href="?page=<?= min($totalPages, $currentPage + 1) ?>">Nächste</a>
                            </li>
                        </ul>
                    </nav>
                <?php endif; ?>
                
            </div>
        </div>
    </div>
    
    <div id="lightbox" class="lightbox" onclick="closeLightbox()">
        <span class="lightbox-close">&times;</span>
        <img id="lightbox-img" src="" alt="">
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.bundle.min.js"></script>

   <script>
        // DOM-Elemente
        const uploadZone = document.querySelector('.upload-zone');
        const fileInput = document.getElementById('file-input');
        const uploadBtn = document.getElementById('upload-btn');
        const browseBtn = document.getElementById('browse-btn');
        const uploadStatusElement = document.getElementById('upload-status'); // Korrigierte ID
        const progressBar = document.getElementById('progressBar');
        const totalProgressText = document.getElementById('totalProgressText');
        const uploadSpeedElement = document.getElementById('uploadSpeed');

        // Drag-and-Drop und Klick-Events
        uploadZone.addEventListener('dragover', (e) => {
            e.preventDefault();
            uploadZone.classList.add('dragover');
        });

        uploadZone.addEventListener('dragleave', () => {
            uploadZone.classList.remove('dragover');
        });

        uploadZone.addEventListener('drop', (e) => {
            e.preventDefault();
            uploadZone.classList.remove('dragover');
            fileInput.files = e.dataTransfer.files;
            handleFiles(fileInput.files);
        });
        
        // Klick auf die Upload-Zone oder den Link öffnet die Dateiauswahl
        uploadZone.addEventListener('click', (e) => {
            // Verhindert, dass der Klick auf den Link das Event doppelt auslöst
            if (e.target.id !== 'browse-btn') {
                fileInput.click();
            }
        });

        browseBtn.addEventListener('click', (e) => {
            e.preventDefault();
            fileInput.click();
        });

        fileInput.addEventListener('change', () => {
            handleFiles(fileInput.files);
        });

        function handleFiles(files) {
            if (files.length > 0) {
                uploadBtn.disabled = false;
                updateStatus(`Bereit zum Upload von ${files.length} Datei(en).`, 'info');
            } else {
                uploadBtn.disabled = true;
                updateStatus('Bitte wählen Sie Bilder aus.', 'warning');
            }
        }
        
        // Upload-Funktion
        const uploadForm = document.getElementById('upload-form');
        let uploadedCount = 0;
        let startTime = 0;
        
        uploadForm.addEventListener('submit', async function(e) {
            e.preventDefault();

            const files = fileInput.files;
            if (files.length === 0) {
                updateStatus('Bitte wählen Sie Bilder aus.', 'warning');
                return;
            }
            
            uploadedCount = 0;
            let errors = [];
            
            updateStatus('Starte Upload...', 'info');
            updateProgress(0, files.length);

            startTime = Date.now();
            const speedInterval = setInterval(updateUploadSpeed, 1000);

            // Einzeln hochladen
            for (let i = 0; i < files.length; i++) {
                const file = files[i];
                const formData = new FormData();
                formData.append('image', file);
                formData.append('ajax_upload', 'true');

                try {
                    const response = await fetch('admin.php', {
                        method: 'POST',
                        body: formData
                    });

                    const result = await response.json();
                    if (result.success) {
                        uploadedCount++;
                        updateProgress(uploadedCount, files.length);
                    } else {
                        errors.push(`${file.name}: ${result.message}`);
                    }
                } catch (error) {
                    errors.push(`${file.name}: Netzwerkfehler`);
                }
            }
            
            clearInterval(speedInterval);
            
            // Status-Meldung anzeigen
            if (errors.length > 0) {
                updateStatus(`Upload abgeschlossen mit Fehlern: ${errors.length} von ${files.length} Bildern`, 'danger');
                console.error("Upload-Fehler:", errors.join('\n'));
            } else {
                updateStatus(`Upload erfolgreich! ${uploadedCount} Bilder hochgeladen.`, 'success');
            }
            
            // Leert das Dateiauswahlfeld, um das erneute Öffnen zu verhindern
            fileInput.value = '';
            
            // Lade die Seite neu, um die neue Bilderliste anzuzeigen
            setTimeout(() => {
                window.location.reload();
            }, 2000);
        });

        // Fortschrittsanzeige
        function updateProgress(completed, total) {
            const percentage = total > 0 ? (completed / total) * 100 : 0;
            progressBar.style.width = percentage + '%';
            totalProgressText.textContent = `${completed} von ${total}`;
        }
        
        function updateUploadSpeed() {
            if (!startTime || uploadedCount === 0) {
                uploadSpeedElement.textContent = '-';
                return;
            }
            const elapsed = (Date.now() - startTime) / 1000;
            const speed = uploadedCount / elapsed;
            uploadSpeedElement.textContent = `${speed.toFixed(1)} Bilder/Sek`;
        }

        function updateStatus(text, type) {
            uploadStatusElement.innerHTML = `<span class="badge bg-${type}">${text}</span>`;
        }

        // Lightbox Functions
        function openLightbox(imageSrc) {
            document.getElementById('lightbox').style.display = 'block';
            document.getElementById('lightbox-img').src = imageSrc;
            document.body.style.overflow = 'hidden';
        }

        function closeLightbox() {
            document.getElementById('lightbox').style.display = 'none';
            document.body.style.overflow = 'auto';
        }

        // Escape-Taste zum Schließen der Lightbox
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                closeLightbox();
            }
        });
    </script>
    <?php endif; ?>
</body>
</html>