<?php
// PHP ohne Datenbank von Volker Niederastroth - Erweiterte Version

// Configuration
$counter_file = 'counter.txt'; // speichert die Daten
$online_timeout = 300; // 5 Minuten in Sekunden "online" status
$lock_duration = 1800; // 30 Minuten in Sekunden für reload

// Function für Counter
function read_counts($file) {
    if (!file_exists($file)) {
        return [
            'total' => 0,
            'today' => 0,
            'this_week' => 0,
            'this_month' => 0,
            'online' => [],
            'last_access' => 0,
        ];
    }
    $data = unserialize(file_get_contents($file));
    // Fehlerbeseitigung
    $defaults = [
        'total' => 0,
        'today' => 0,
        'this_week' => 0,
        'this_month' => 0,
        'online' => [],
        'last_access' => 0,
    ];
    return array_merge($defaults, $data);
}

// Schreiben der Daten
function write_counts($file, $data) {
    file_put_contents($file, serialize($data));
}

// IP Adresse einlesen
$ip = $_SERVER['REMOTE_ADDR'];

// Zähler lesen
$counts = read_counts($counter_file);

// IP checken
$ip_lock_file = 'ip_locks.txt';
$ip_locks = file_exists($ip_lock_file) ? unserialize(file_get_contents($ip_lock_file)) : [];
$locked = isset($ip_locks[$ip]) && (time() - $ip_locks[$ip] < $lock_duration);

// IP OK, dann zählen
if (!$locked) {
    $current_time = time();
    $current_date = date('Y-m-d');
    $current_week = date('W');
    $current_month = date('Y-m');

    // Daten aktualisieren
    $last_access_date = date('Y-m-d', $counts['last_access']);
    $last_access_week = date('W', $counts['last_access']);
    $last_access_month = date('Y-m', $counts['last_access']);

    if ($current_date !== $last_access_date) {
        $counts['today'] = 1;
    } else {
        $counts['today']++;
    }

    if ($current_week !== $last_access_week) {
        $counts['this_week'] = 1;
    } else {
        $counts['this_week']++;
    }

    if ($current_month !== $last_access_month) {
        $counts['this_month'] = 1;
    } else {
        $counts['this_month']++;
    }

    // Total Zähler
    $counts['total']++;
    $counts['last_access'] = $current_time;

    // IP Sperre einrichten
    $ip_locks[$ip] = $current_time;
    write_counts($ip_lock_file, $ip_locks);
}

// IP Sperre löschen
$new_ip_locks = [];
foreach ($ip_locks as $locked_ip => $timestamp) {
    if (time() - $timestamp < $lock_duration) {
        $new_ip_locks[$locked_ip] = $timestamp;
    }
}
write_counts($ip_lock_file, $new_ip_locks);

// Update Zähler
$counts['online'][$ip] = time();

// Löschen der alten Zählerstände
$new_online_visitors = [];
foreach ($counts['online'] as $online_ip => $timestamp) {
    if (time() - $timestamp < $online_timeout) {
        $new_online_visitors[$online_ip] = $timestamp;
    }
}
$counts['online'] = $new_online_visitors;

// Update schreiben
write_counts($counter_file, $counts);

// Vorbereiten der Ausgabe
$visitors_online = count($counts['online']);
$visitors_total = $counts['total'];
$visitors_today = $counts['today'];
$visitors_week = $counts['this_week'];
$visitors_month = $counts['this_month'];

// Lade die gespeicherten Stile
$styles_file = 'counter_styles.json';
$custom_styles = [];
if (file_exists($styles_file)) {
    $custom_styles = json_decode(file_get_contents($styles_file), true);
}

// Erweiterte Standardwerte
$font_family = $custom_styles['font-family'] ?? 'Arial, sans-serif';
$font_size = $custom_styles['font-size'] ?? '16px'; 
$font_weight = $custom_styles['font-weight'] ?? 'normal';
$text_color = $custom_styles['color'] ?? '#ffffff';
$background_color = $custom_styles['background-color'] ?? '#000000';
$background_gradient = $custom_styles['background-gradient'] ?? '';
$border = $custom_styles['border'] ?? '1px solid #ccc';
$border_radius = $custom_styles['border-radius'] ?? '0px';
$box_shadow = $custom_styles['box-shadow'] ?? 'none';
$padding = $custom_styles['padding'] ?? '10px';
$margin = $custom_styles['margin'] ?? '20px';
$width = $custom_styles['width'] ?? '300px'; 
$min_width = $custom_styles['min-width'] ?? '250px';
$max_width = $custom_styles['max-width'] ?? 'none';
$height = $custom_styles['height'] ?? 'auto'; 
$min_height = $custom_styles['min-height'] ?? 'auto';
$text_align = $custom_styles['text-align'] ?? 'left';
$line_height = $custom_styles['line-height'] ?? '1.5';
$opacity = $custom_styles['opacity'] ?? '1';
$display_type = $custom_styles['display-type'] ?? 'block';

// Background-Behandlung (Gradient hat Vorrang vor einfacher Farbe)
$background_style = !empty($background_gradient) ? $background_gradient : $background_color;

?>

<div class="visitor-counter">
    <style>
        .visitor-counter {
            font-family: <?php echo htmlspecialchars($font_family); ?>;
            font-size: <?php echo htmlspecialchars($font_size); ?>; 
            font-weight: <?php echo htmlspecialchars($font_weight); ?>;
            border: <?php echo htmlspecialchars($border); ?>;
            border-radius: <?php echo htmlspecialchars($border_radius); ?>;
            box-shadow: <?php echo htmlspecialchars($box_shadow); ?>;
            padding: <?php echo htmlspecialchars($padding); ?>;
            margin: <?php echo htmlspecialchars($margin); ?>;
            background: <?php echo htmlspecialchars($background_style); ?>;
            color: <?php echo htmlspecialchars($text_color); ?>;
            width: <?php echo htmlspecialchars($width); ?>;
            min-width: <?php echo htmlspecialchars($min_width); ?>;
            max-width: <?php echo htmlspecialchars($max_width); ?>;
            height: <?php echo htmlspecialchars($height); ?>;
            min-height: <?php echo htmlspecialchars($min_height); ?>;
            text-align: <?php echo htmlspecialchars($text_align); ?>;
            line-height: <?php echo htmlspecialchars($line_height); ?>;
            opacity: <?php echo htmlspecialchars($opacity); ?>;
            display: <?php echo htmlspecialchars($display_type); ?>;
            /* Box-Sizing für bessere Kontrolle */
            box-sizing: border-box;
        }
        .visitor-counter h4 {
            margin: 0 0 10px 0;
            color: inherit;
            font-size: inherit;
        }
        .visitor-counter p {
            margin: 5px 0;
            color: inherit;
            font-size: inherit;
        }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            .visitor-counter {
                width: 100% !important;
                max-width: 100% !important;
                margin: 10px 0 !important;
            }
        }
    </style>
    <h4>Besucherstatistik</h4>
    <p>Besucher online: <?php echo $visitors_online; ?></p>
    <p>Besucher heute: <?php echo $visitors_today; ?></p>
    <p>Besucher diese Woche: <?php echo $visitors_week; ?></p>
    <p>Besucher diesen Monat: <?php echo $visitors_month; ?></p>
    <p>Gesamtbesucher: <?php echo $visitors_total; ?></p>
</div>