<?php
// PHP-Skript zur Generierung eines Passwort-Hashes

// Prüfen, ob das Formular abgeschickt wurde und ein Passwort übermittelt wurde
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['password'])) {
    
    // Das vom Benutzer eingegebene Passwort holen
    $plain_password = $_POST['password'];

    // Den Hash mit der empfohlenen Methode erzeugen
    $hashed_password = password_hash($plain_password, PASSWORD_DEFAULT);
    
    // Eine Erfolgsmeldung für die Ausgabe speichern
    $message = "Hash erfolgreich generiert!";
}
?>

<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Passwort-Hash Generator</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .container {
            margin-top: 50px;
        }
    </style>
</head>
<body>

<div class="container">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">Passwort-Hash Generator</h5>
        </div>
        <div class="card-body">
            
            <?php if (isset($message)): ?>
                <div class="alert alert-success" role="alert">
                    <?= $message ?>
                </div>
                <div class="form-group mb-3">
                    <label for="hashOutput">Kopieren Sie diesen Hash:</label>
                    <textarea class="form-control" id="hashOutput" rows="3" readonly><?= htmlspecialchars($hashed_password); ?></textarea>
                </div>
                <button class="btn btn-secondary" onclick="document.getElementById('hashOutput').select(); document.execCommand('copy');">Hash kopieren</button>
                <a href="passworterstellen.php" class="btn btn-link">Neuen Hash erzeugen</a>
            <?php else: ?>
                <form method="POST">
                    <div class="form-group mb-3">
                        <label for="passwordInput">Geben Sie das Passwort ein:</label>
                        <input type="password" class="form-control" id="passwordInput" name="password" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Hash generieren</button>
                </form>
            <?php endif; ?>

        </div>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
</body>
</html>