<?php
session_start();
if (!isset($_SESSION['admin'])) { header("Location: login.php"); exit; }

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'phpmailer/src/Exception.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/SMTP.php';

$config = require "config.php";
$pdo = new PDO("mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4",
               $config['db_user'], $config['db_pass']);

$msg = '';
$activeTab = 'send'; // Standard-Tab

// Newsletter senden
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['betreff'])) {
    $betreff = $_POST['betreff'] ?? '';
    $inhalt  = $_POST['inhalt'] ?? '';

    $stmt = $pdo->query("SELECT email FROM newsletter_abonnenten");
    $emails = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    $successCount = 0;
    $errorCount = 0;

    foreach ($emails as $email) {
        $mail = new PHPMailer(true);
        try {
            $mail->CharSet = 'UTF-8';
            $mail->isSMTP();
            $mail->Host = 'localhost';
            $mail->SMTPAuth = false;
            $mail->Port = 25;

            // ==== Optional SMTP: aktivieren wenn gewünscht ====
            /*
            $mail->isSMTP();
            $mail->Host = 'smtp.deinedomain.de';
            $mail->SMTPAuth = true;
            $mail->Username = 'dein_smtp_user';
            $mail->Password = 'dein_smtp_passwort';
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS; // oder ENCRYPTION_SMTPS
            $mail->Port = 587; // SMTP-Port
            */

            $mail->setFrom('deine@eimail.de','Newsletter');
            $mail->addAddress($email);

            // Abmelden-Link für jeden Empfänger einsetzen
            $mailContent = str_replace(
                '{{unsubscribe_link}}',
                '/austragen.php?email='.urlencode($email),
                $inhalt
            );

            $mail->isHTML(true);
            $mail->Subject = $betreff;
            $mail->Body = $mailContent;
            $mail->AltBody = strip_tags($mailContent);

            $mail->send();
            $successCount++;
        } catch (Exception $e) {
            $errorCount++;
            $msg .= "<div class='alert alert-warning'>Fehler an $email: {$mail->ErrorInfo}</div>";
        }
    }
    
    // Newsletter im Archiv speichern
    if ($successCount > 0) {
        $stmt = $pdo->prepare("INSERT INTO newsletter_archiv (betreff, inhalt, empfaenger_anzahl) VALUES (?, ?, ?)");
        $stmt->execute([$betreff, $inhalt, $successCount]);
        
        $msg .= "<div class='alert alert-success'>Newsletter wurde an {$successCount} Empfänger gesendet und im Archiv gespeichert!</div>";
    }
    
    if ($errorCount > 0) {
        $msg .= "<div class='alert alert-warning'>{$errorCount} E-Mails konnten nicht gesendet werden.</div>";
    }
    
    $activeTab = 'send';
}

// Newsletter aus Archiv löschen
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_archive_id'])) {
    $archiveId = (int)$_POST['delete_archive_id'];
    $stmt = $pdo->prepare("DELETE FROM newsletter_archiv WHERE id = ?");
    $stmt->execute([$archiveId]);
    $msg = "<div class='alert alert-success'>Newsletter wurde aus dem Archiv gelöscht!</div>";
    $activeTab = 'archive';
}

// Newsletter aus Archiv wiederverwenden
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['reuse_id'])) {
    $reuseId = (int)$_GET['reuse_id'];
    $stmt = $pdo->prepare("SELECT betreff, inhalt FROM newsletter_archiv WHERE id = ?");
    $stmt->execute([$reuseId]);
    $reuseData = $stmt->fetch(PDO::FETCH_ASSOC);
    $activeTab = 'send';
}

// Abonnentenliste laden
$stmt = $pdo->query("SELECT id, email FROM newsletter_abonnenten ORDER BY id DESC");
$abonnenten = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Archiv laden
$stmt = $pdo->query("SELECT id, betreff, inhalt, gesendet_am, empfaenger_anzahl FROM newsletter_archiv ORDER BY gesendet_am DESC");
$archiv = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html lang="de">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Newsletter Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<script src="js/tinymce/tinymce.min.js"></script>
</head>
<body class="bg-light">
<div class="container mt-5">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Newsletter Administration</h2>
        <a href="logout.php" class="btn btn-secondary">Logout</a>
    </div>

    <?php if($msg) echo $msg; ?>

    <!-- Navigation Tabs -->
    <ul class="nav nav-tabs mb-4" id="mainTabs" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link <?= $activeTab === 'send' ? 'active' : '' ?>" id="send-tab" data-bs-toggle="tab" data-bs-target="#send-pane" type="button" role="tab">
                <i class="fas fa-paper-plane me-2"></i>Newsletter senden
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link <?= $activeTab === 'archive' ? 'active' : '' ?>" id="archive-tab" data-bs-toggle="tab" data-bs-target="#archive-pane" type="button" role="tab">
                <i class="fas fa-archive me-2"></i>Archiv (<?= count($archiv) ?>)
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="subscribers-tab" data-bs-toggle="tab" data-bs-target="#subscribers-pane" type="button" role="tab">
                <i class="fas fa-users me-2"></i>Abonnenten (<?= count($abonnenten) ?>)
            </button>
        </li>
    </ul>

    <div class="tab-content" id="mainTabContent">
        <!-- Newsletter senden Tab -->
        <div class="tab-pane fade <?= $activeTab === 'send' ? 'show active' : '' ?>" id="send-pane" role="tabpanel">
            <form method="POST">
                <div class="mb-3">
                    <label for="betreff" class="form-label">Betreff</label>
                    <input type="text" name="betreff" id="betreff" class="form-control" 
                           value="<?= isset($reuseData) ? htmlspecialchars($reuseData['betreff']) : '' ?>" 
                           placeholder="Newsletter Betreff" required>
                </div>
                <div class="mb-3">
                    <label for="inhalt" class="form-label">Inhalt</label>
                    <textarea name="inhalt" class="tinymce"><?= isset($reuseData) ? htmlspecialchars($reuseData['inhalt']) : '' ?></textarea>
                </div>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-paper-plane me-2"></i>Newsletter senden
                </button>
            </form>
        </div>

        <!-- Archiv Tab -->
        <div class="tab-pane fade <?= $activeTab === 'archive' ? 'show active' : '' ?>" id="archive-pane" role="tabpanel">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Newsletter Archiv</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="archivTable" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Betreff</th>
                                    <th>Gesendet am</th>
                                    <th>Empfänger</th>
                                    <th>Aktionen</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($archiv as $newsletter): ?>
                                    <tr>
                                        <td><?= $newsletter['id'] ?></td>
                                        <td><?= htmlspecialchars($newsletter['betreff']) ?></td>
                                        <td><?= date('d.m.Y H:i', strtotime($newsletter['gesendet_am'])) ?></td>
                                        <td><span class="badge bg-info"><?= $newsletter['empfaenger_anzahl'] ?></span></td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <button type="button" class="btn btn-sm btn-outline-primary" 
                                                        onclick="showPreview(<?= $newsletter['id'] ?>)" title="Vorschau">
                                                    <i class="fas fa-eye"></i>
                                                </button>
                                                <a href="?reuse_id=<?= $newsletter['id'] ?>" class="btn btn-sm btn-outline-success" title="Wiederverwenden">
                                                    <i class="fas fa-recycle"></i>
                                                </a>
                                                <button type="button" class="btn btn-sm btn-outline-danger" 
                                                        onclick="deleteNewsletter(<?= $newsletter['id'] ?>)" title="Löschen">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Abonnenten Tab -->
        <div class="tab-pane fade" id="subscribers-pane" role="tabpanel">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Abonnentenliste</h5>
                </div>
                <div class="card-body">
                    <table id="abonnentenTable" class="table table-bordered table-striped">
                        <thead>
                            <tr><th>#</th><th>E-Mail</th></tr>
                        </thead>
                        <tbody>
                            <?php foreach ($abonnenten as $abo): ?>
                                <tr><td><?= $abo['id'] ?></td><td><?= htmlspecialchars($abo['email']) ?></td></tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Vorschau Modal -->
<div class="modal fade" id="previewModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Newsletter Vorschau</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="previewContent"></div>
            </div>
        </div>
    </div>
</div>

<!-- Verstecktes Form für Lösch-Aktionen -->
<form id="deleteForm" method="POST" style="display: none;">
    <input type="hidden" name="delete_archive_id" id="deleteArchiveId">
</form>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
// TinyMCE initialisieren
tinymce.init({
    selector: 'textarea.tinymce',
    height: 400,
    menubar: false,
    plugins: 'link image code lists emoticons textcolor table',
    toolbar: 'undo redo  | fontfamily | styleselect fontselect | fontsizeinput | fontsizeselect bold italic underline | emoticons | alignleft aligncenter alignright | bullist numlist | forecolor backcolor | link image | code | addUnsubscribe',
    language: 'en',
    relative_urls: false,
    remove_script_host: false,
    setup: function(editor) {
        // Standardtext mit Abmelden-Link
        editor.on('init', function() {
            if(editor.getContent() === '' && !<?= isset($reuseData) ? 'true' : 'false' ?>) {
                editor.setContent('<p>Hier kommt dein Newsletter-Text.</p><p><a href="{{unsubscribe_link}}">Abmelden</a></p>');
            }
        });
        // Button zum Einfügen des Abmelden-Links
        editor.ui.registry.addButton('addUnsubscribe', {
            text: 'Abmelden-Link',
            onAction: function() {
                editor.insertContent('<a href="{{unsubscribe_link}}">Abmelden</a>');
            }
        });
    }
});

// DataTables initialisieren
$(document).ready(function () {
    const deutscheSprachdatei = {
        "decimal": "",
        "emptyTable": "Keine Daten in der Tabelle",
        "info": "Zeige _START_ bis _END_ von _TOTAL_ Einträgen",
        "infoEmpty": "Zeige 0 bis 0 von 0 Einträgen",
        "infoFiltered": "(gefiltert von _MAX_ Einträgen)",
        "thousands": ",",
        "lengthMenu": "Zeige _MENU_ Einträge",
        "loadingRecords": "Lade...",
        "processing": "Bitte warten...",
        "search": "Suchen:",
        "zeroRecords": "Keine passenden Einträge gefunden",
        "paginate": {
            "first": "Erste",
            "last": "Letzte",
            "next": "Nächste",
            "previous": "Vorherige"
        }
    };

    $('#abonnentenTable').DataTable({
        "pageLength": 25,
        "order": [[0, "desc"]],
        "language": deutscheSprachdatei
    });

    $('#archivTable').DataTable({
        "pageLength": 10,
        "order": [[0, "desc"]],
        "language": deutscheSprachdatei,
        "columnDefs": [
            { "orderable": false, "targets": [4] }
        ]
    });
});

// Newsletter Archiv Daten für Vorschau
const archivData = <?= json_encode($archiv) ?>;

function showPreview(id) {
    const newsletter = archivData.find(n => n.id == id);
    if (newsletter) {
        document.getElementById('previewContent').innerHTML = 
            '<h6>Betreff: ' + newsletter.betreff + '</h6>' +
            '<hr>' + 
            newsletter.inhalt;
        new bootstrap.Modal(document.getElementById('previewModal')).show();
    }
}

function deleteNewsletter(id) {
    if (confirm('Möchten Sie diesen Newsletter wirklich aus dem Archiv löschen?')) {
        document.getElementById('deleteArchiveId').value = id;
        document.getElementById('deleteForm').submit();
    }
}
</script>
</body>
</html>