<?php
$config = require "config.php";
$pdo = new PDO("mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4",
               $config['db_user'], $config['db_pass']);

$message = '';
$messageType = '';

if (isset($_GET['email'])) {
    $email = filter_var($_GET['email'], FILTER_VALIDATE_EMAIL);
    
    if ($email) {
        // Aus aktiven Abonnenten entfernen
        $stmt = $pdo->prepare("DELETE FROM newsletter_abonnenten WHERE email = ?");
        $stmt->execute([$email]);
        
        // Auch aus Pending entfernen (falls noch nicht bestätigt)
        $stmt2 = $pdo->prepare("DELETE FROM newsletter_pending WHERE email = ?");
        $stmt2->execute([$email]);
        
        if ($stmt->rowCount() > 0 || $stmt2->rowCount() > 0) {
            $message = 'Sie wurden erfolgreich vom Newsletter abgemeldet.';
            $messageType = 'success';
        } else {
            $message = 'Diese E-Mail-Adresse war nicht für den Newsletter angemeldet.';
            $messageType = 'info';
        }
    } else {
        $message = 'Ungültige E-Mail-Adresse.';
        $messageType = 'danger';
    }
}

// Manuelle Abmeldung per Formular
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['email'])) {
    $email = filter_var($_POST['email'], FILTER_VALIDATE_EMAIL);
    
    if ($email) {
        // Aus aktiven Abonnenten entfernen
        $stmt = $pdo->prepare("DELETE FROM newsletter_abonnenten WHERE email = ?");
        $stmt->execute([$email]);
        
        // Auch aus Pending entfernen
        $stmt2 = $pdo->prepare("DELETE FROM newsletter_pending WHERE email = ?");
        $stmt2->execute([$email]);
        
        if ($stmt->rowCount() > 0 || $stmt2->rowCount() > 0) {
            $message = 'Sie wurden erfolgreich vom Newsletter abgemeldet.';
            $messageType = 'success';
        } else {
            $message = 'Diese E-Mail-Adresse war nicht für den Newsletter angemeldet.';
            $messageType = 'info';
        }
    } else {
        $message = 'Bitte geben Sie eine gültige E-Mail-Adresse ein.';
        $messageType = 'danger';
    }
}
?>

<!doctype html>
<html lang="de">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Newsletter Abmeldung</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            background: linear-gradient(135deg, #ffeaa7 0%, #fab1a0 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
        }
        .unsubscribe-card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }
        .card-header {
            background: linear-gradient(135deg, #ffeaa7 0%, #fab1a0 100%);
            color: #2d3436;
            padding: 2rem;
            text-align: center;
        }
        .card-body {
            padding: 2rem;
        }
        .btn-unsubscribe {
            background: linear-gradient(135deg, #ffeaa7 0%, #fab1a0 100%);
            border: none;
            color: #2d3436;
            padding: 12px 30px;
            font-weight: 600;
        }
        .btn-unsubscribe:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            color: #2d3436;
        }
        .form-control:focus {
            border-color: #fab1a0;
            box-shadow: 0 0 0 0.2rem rgba(250, 177, 160, 0.25);
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-5">
                <div class="unsubscribe-card">
                    <div class="card-header">
                        <h2 class="mb-0">
                            <i class="fas fa-envelope-open me-2"></i>Newsletter Abmeldung
                        </h2>
                        <p class="mb-0 mt-2 opacity-90">Schade, dass Sie uns verlassen möchten</p>
                    </div>
                    <div class="card-body">
                        <?php if ($message): ?>
                            <div class="alert alert-<?= $messageType ?> alert-dismissible fade show" role="alert">
                                <i class="fas fa-<?= $messageType === 'success' ? 'check-circle' : ($messageType === 'info' ? 'info-circle' : 'exclamation-triangle') ?> me-2"></i>
                                <?= $message ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>

                        <?php if ($messageType !== 'success'): ?>
                            <form method="POST" class="needs-validation" novalidate>
                                <div class="mb-4">
                                    <label for="email" class="form-label fw-semibold">
                                        <i class="fas fa-at me-1"></i>E-Mail-Adresse
                                    </label>
                                    <input type="email" 
                                           class="form-control form-control-lg" 
                                           id="email" 
                                           name="email" 
                                           value="<?= isset($_GET['email']) ? htmlspecialchars($_GET['email']) : '' ?>"
                                           placeholder="ihre.email@example.com"
                                           required>
                                    <div class="invalid-feedback">
                                        Bitte geben Sie eine gültige E-Mail-Adresse ein.
                                    </div>
                                </div>
                                
                                <div class="d-grid">
                                    <button type="submit" class="btn btn-warning btn-lg btn-unsubscribe">
                                        <i class="fas fa-sign-out-alt me-2"></i>Vom Newsletter abmelden
                                    </button>
                                </div>
                            </form>
                        <?php else: ?>
                            <div class="text-center">
                                <i class="fas fa-check-circle text-success" style="font-size: 3rem;"></i>
                                <h4 class="mt-3 text-success">Erfolgreich abgemeldet!</h4>
                                <p class="text-muted">Sie erhalten keine weiteren Newsletter von uns.</p>
                                <a href="eintragen.php" class="btn btn-primary">
                                    <i class="fas fa-envelope me-2"></i>Doch wieder anmelden?
                                </a>
                            </div>
                        <?php endif; ?>

                        <div class="mt-4 p-3 bg-light rounded">
                            <div class="d-flex align-items-start">
                                <i class="fas fa-info-circle text-info me-3 mt-1"></i>
                                <div>
                                    <h6 class="mb-1">Information zur Abmeldung</h6>
                                    <small class="text-muted">
                                        Nach der Abmeldung werden Sie sofort aus unserem Verteiler entfernt. 
                                        Sie können sich jederzeit wieder anmelden, falls Sie Ihre Meinung ändern.
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Bootstrap form validation
        (function() {
            'use strict';
            window.addEventListener('load', function() {
                var forms = document.getElementsByClassName('needs-validation');
                var validation = Array.prototype.filter.call(forms, function(form) {
                    form.addEventListener('submit', function(event) {
                        if (form.checkValidity() === false) {
                            event.preventDefault();
                            event.stopPropagation();
                        }
                        form.classList.add('was-validated');
                    }, false);
                });
            }, false);
        })();
    </script>
</body>
</html>