<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once 'config.php';

// Default-Parameter
$headerfarbe = '#0d6efd';
$bildBreite = 250;
$textHintergrund = '#ffffff';
$cardHintergrund = '#f8f9fa';

// Einstellungen aus der DB laden
$settingsResult = $conn->query("SELECT * FROM settings WHERE id = 1");
$settings = $settingsResult->fetch(PDO::FETCH_ASSOC);

if ($settings) {
    $headerfarbeDB = $settings['headerfarbe'] ?? $headerfarbe;
    $bildBreiteDB = isset($settings['bild_breite']) ? (int)$settings['bild_breite'] : $bildBreite;
    $textHintergrundDB = $settings['text_hintergrund'] ?? $textHintergrund;
    $cardHintergrundDB = $settings['card_hintergrund'] ?? $cardHintergrund;
} else {
    $headerfarbeDB = $headerfarbe;
    $bildBreiteDB = $bildBreite;
    $textHintergrundDB = $textHintergrund;
    $cardHintergrundDB = $cardHintergrund;
}

// Funktion zur Validierung von Hex-Farben
function validateHexColor($color) {
    return preg_match('/^#[0-9a-fA-F]{6}$/', $color);
}

// Werte per GET überschreiben, falls vorhanden und valide
$headerfarbe = isset($_GET['headerfarbe']) && validateHexColor($_GET['headerfarbe']) 
    ? $_GET['headerfarbe'] 
    : $headerfarbeDB;

$bildBreite = isset($_GET['bildBreite']) && is_numeric($_GET['bildBreite']) && $_GET['bildBreite'] > 0 
    ? (int)$_GET['bildBreite'] 
    : $bildBreiteDB;

$textHintergrund = isset($_GET['textHintergrund']) && validateHexColor($_GET['textHintergrund']) 
    ? $_GET['textHintergrund'] 
    : $textHintergrundDB;

$cardHintergrund = isset($_GET['cardHintergrund']) && validateHexColor($_GET['cardHintergrund']) 
    ? $_GET['cardHintergrund'] 
    : $cardHintergrundDB;

// Pagination
$newsParPage = isset($settings['news_par_page']) ? (int)$settings['news_par_page'] : 3;
$page = isset($_GET['seite']) ? max(1, (int)$_GET['seite']) : 1;
$offset = ($page - 1) * $newsParPage;

// Gesamtanzahl News
$total = $conn->query("SELECT COUNT(*) AS total FROM news")->fetch(PDO::FETCH_ASSOC)['total'] ?? 0;
$totalPages = ceil($total / $newsParPage);

// Dynamisches Styling ausgeben
echo '<style>
.news-image {
   width: ' . $bildBreite . 'px;
   max-width: 100%;
   height: auto;
   margin-bottom: 10px;
}
.header {
    background-color: ' . htmlspecialchars($headerfarbe) . ';
    color: white;
    padding: 20px;
    border-radius: 5px;
}
.card-text {
    background-color: ' . htmlspecialchars($textHintergrund) . ';
    padding: 15px;
    border-radius: 5px;
}
.card {
    background-color: ' . htmlspecialchars($cardHintergrund) . ';
}
.news-titel,
.news-datum {
    /* Hier Farbe über Inline-Style in PHP gesetzt */
}
</style>';

// Scrollanker direkt vor den News
echo '<div id="news-anfang"></div>';

// BEGIN Container zum Ein-/Ausblenden via JS
echo '<div id="news-content">';

// News laden
$stmt = $conn->prepare("SELECT * FROM news ORDER BY datum DESC LIMIT :limit OFFSET :offset");
$stmt->bindValue(':limit', $newsParPage, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();
$news = $stmt->fetchAll(PDO::FETCH_ASSOC);

// News ausgeben
foreach ($news as $n) {
    echo '<div class="card mb-4">';
    echo '<div class="card-body">';
    
    // Farbe für Titel und Datum (Fallback Schwarz)
    $farbe = (isset($n['titel_farbe']) && validateHexColor($n['titel_farbe'])) ? $n['titel_farbe'] : '#000000';

    echo '<h4 class="card-title news-titel" style="color:' . htmlspecialchars($farbe) . ';">' . htmlspecialchars($n['titel']) . '</h4>';
    // Datum mit gleicher Farbe wie Titel:
    echo '<p class="news-datum" style="color:' . htmlspecialchars($farbe) . ';">' . date('d.m.Y', strtotime($n['datum'])) . '</p>';

    echo '<div class="row g-3 align-items-start">';

    if (!empty($n['bild']) && file_exists('uploads/' . $n['bild'])) {
        echo '<div class="col-md-4">';
        echo '<img src="uploads/' . htmlspecialchars($n['bild']) . '" class="img-fluid rounded shadow-sm news-image" alt="Bild">';
        echo '</div><div class="col-md-8">';
    } else {
        echo '<div class="col-12">';
    }

    echo '<div class="card-text">' . $n['text'] . '</div>';
    echo '</div>'; // Ende col
    echo '</div>'; // Ende row
    echo '</div></div>'; // Ende card-body + card
}

// Pagination ausgeben (max. 5 Buttons)
if ($totalPages > 1) {
    echo '<nav><ul class="pagination justify-content-center">';

    $start = max(1, $page - 2);
    $end = min($totalPages, $start + 4);

    if ($page > 1) {
        echo '<li class="page-item"><a class="page-link" href="#" data-page="' . ($page - 1) . '">&laquo;</a></li>';
    }

    for ($i = $start; $i <= $end; $i++) {
        $active = ($i === $page) ? 'active' : '';
        echo '<li class="page-item ' . $active . '"><a class="page-link" href="#" data-page="' . $i . '">' . $i . '</a></li>';
    }

    if ($page < $totalPages) {
        echo '<li class="page-item"><a class="page-link" href="#" data-page="' . ($page + 1) . '">&raquo;</a></li>';
    }

    echo '</ul></nav>';
}

echo '</div>'; // ENDE news-content
