<?php
require_once 'config.php';

// Titel- und Hintergrundfarbe laden (Fallbacks, falls Felder fehlen)
$stmtBg = $conn->query("SELECT body_hintergrund, titel_farbe FROM settings WHERE id=1");
$settings = $stmtBg->fetch(PDO::FETCH_ASSOC);

$bodyBgColor = $settings['body_hintergrund'] ?? '#f8f9fa';
$titelFarbe  = $settings['titel_farbe'] ?? '#000000';
?>
<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="UTF-8" />
  <title>News</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
  <style>
    body {
      background-color: <?= htmlspecialchars($bodyBgColor) ?>;
    }
    .fade-in {
      animation: fadeIn 0.5s ease-in-out;
    }
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(10px); }
      to { opacity: 1; transform: translateY(0); }
    }
    /* Titel- und Datumfarbe gleich */
    .news-titel,
    .news-datum {
      color: <?= htmlspecialchars($titelFarbe) ?>;
    }
  </style>
</head>
<body>
  <div class="container mt-4" id="news-anfang">
    <div class="header mb-4">
      <h1>Aktuelle News</h1>
    </div>
    <div id="news-container">Neuigkeiten werden geladen...</div>
  </div>

  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    function adjustIframeHeight() {
      if (window.frameElement) {
        const iframe = window.frameElement;
        const newHeight = document.documentElement.scrollHeight;
        iframe.style.height = newHeight + 'px';
      }
    }

    function scrollParentToNews() {
      if (window.parent && window.parent !== window) {
        const iframes = window.parent.document.getElementsByTagName('iframe');
        for (let i = 0; i < iframes.length; i++) {
          if (iframes[i].contentWindow === window) {
            const newsAnker = document.getElementById('news-anfang');
            if (newsAnker) {
              const offsetTop = newsAnker.getBoundingClientRect().top + window.pageYOffset;
              const iframeRect = iframes[i].getBoundingClientRect();
              const parentScrollTop = window.parent.scrollY || window.parent.pageYOffset;
              const menuOffset = 120;
              window.parent.scrollTo({
                top: parentScrollTop + iframeRect.top + offsetTop - menuOffset,
                behavior: 'smooth'
              });
            }
            break;
          }
        }
      }
    }

    function ladeNews(seite = 1) {
      $("#news-container").html('<div class="text-center p-4"><div class="spinner-border" role="status"></div> Laden...</div>');

      $.get("load_news.php", { seite: seite, t: new Date().getTime() }, function(data) {
        $("#news-container").html(data);
        $("#news-container .card").addClass("fade-in");
        adjustIframeHeight();
        setTimeout(adjustIframeHeight, 300);
        scrollParentToNews();
      });
    }

    $(document).ready(function() {
      const urlParams = new URLSearchParams(window.location.search);
      let aktuelleSeite = parseInt(urlParams.get('seite')) || 1;

      const refreshKey = "newsRefreshed_page" + aktuelleSeite;
      if (!sessionStorage.getItem(refreshKey)) {
        sessionStorage.setItem(refreshKey, "true");
        window.location.href = "?seite=" + aktuelleSeite;
        return;
      }

      ladeNews(aktuelleSeite);

      $("#news-container").on('click', '.page-link', function(e) {
        e.preventDefault();
        const neueSeite = $(this).data("page");
        if (neueSeite) {
          window.location.href = "?seite=" + neueSeite;
        }
      });
    });
  </script>
</body>
</html>
