<?php
session_start();
require_once '../config.php';
if (!isset($_SESSION["connecte"])) {
    header("Location: index.php");
    exit;
}

$id = $_GET["id"] ?? null;
if (!$id) {
    header("Location: dashboard.php");
    exit;
}

$stmt = $conn->prepare("SELECT * FROM news WHERE id = ?");
$stmt->execute([$id]);
$news = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$news) {
    die("News introuvable.");
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $titre = $_POST["titre"] ?? '';
    $texte = $_POST["text"] ?? '';
    $datum = $_POST["datum"] ?? '';
    $titel_farbe = $_POST["titel_farbe"] ?? $news['titel_farbe'] ?? '#000000';
    $imageName = $news["bild"];

    $dateObj = DateTime::createFromFormat('Y-m-d', $datum);
    if (!$dateObj) {
        $error = "Ungültiges Datum!";
    } else {
        $datum = $dateObj->format('Y-m-d');

        if (!empty($_FILES["bild"]["name"])) {
            $allowed = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
            $targetDir = "../uploads/";
            $extension = strtolower(pathinfo($_FILES["bild"]["name"], PATHINFO_EXTENSION));

            if (in_array($extension, $allowed)) {
                $imageName = uniqid("news_") . "." . $extension;
                move_uploaded_file($_FILES["bild"]["tmp_name"], $targetDir . $imageName);
            }
        }

        $stmt = $conn->prepare("UPDATE news SET titel = ?, text = ?, bild = ?, datum = ?, titel_farbe = ? WHERE id = ?");
        $stmt->execute([$titre, $texte, $imageName, $datum, $titel_farbe, $id]);

        header("Location: dashboard.php");
        exit;
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Bearbeiten der Nachrichten</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="../js/tinymce/tinymce.min.js"></script>
    <script>
        tinymce.init({
            selector: 'textarea.tinymce',
            height: 300,
            menubar: false,
            plugins: 'link image code lists emoticons textcolor',
            toolbar: 'undo redo  | fontfamily | styleselect fontselect | fontsizeinput | fontsizeselect bold italic underline | emoticons | alignleft aligncenter alignright | bullist numlist | forecolor backcolor | link image | code' ,
            language: 'en',
            relative_urls: false,
            remove_script_host: false
        });
    </script>
</head>
<body class="bg-light">
<div class="container mt-4">
    <h2>Bearbeiten der Nachrichten</h2>

    <?php if (!empty($error)): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="post" enctype="multipart/form-data">
        <div class="mb-3">
            <label>Titel</label>
            <input type="text" name="titre" class="form-control" value="<?= htmlspecialchars($news['titel']) ?>" required>
        </div>
        <div class="mb-3">
            <label>Titel Farbe</label>
            <input type="color" name="titel_farbe" class="form-control form-control-color" value="<?= htmlspecialchars($news['titel_farbe'] ?? '#000000') ?>" title="Wähle eine Farbe">
        </div>
        <div class="mb-3">
            <label>Datum</label>
            <input type="date" name="datum" class="form-control" value="<?= htmlspecialchars(date('Y-m-d', strtotime($news['datum']))) ?>" required>
        </div>
        <div class="mb-3">
            <label>Text</label>
            <textarea name="text" class="form-control tinymce"><?= htmlspecialchars_decode($news["text"]) ?></textarea>
        </div>
        <div class="mb-3">
            <label>Aktuelles Bild</label><br>
            <?php if (!empty($news["bild"]) && file_exists("../uploads/" . $news["bild"])): ?>
                <img src="../uploads/<?= htmlspecialchars($news['bild']) ?>" style="max-width:200px"><br>
            <?php else: ?>
                <span>Kein Bild</span><br>
            <?php endif; ?>
            <label>Bild ändern</label>
            <input type="file" name="bild" class="form-control mt-2">
        </div>
        <button class="btn btn-primary">Aktualisieren</button>
        <a href="dashboard.php" class="btn btn-secondary">Zurück</a>
    </form>
</div>
</body>
</html>
