<?php
// Session-Cookie für www und non-www Domain konfigurieren  
$domain = $_SERVER["HTTP_HOST"];
if (strpos($domain, "www.") === 0) {
    $domain = substr($domain, 4);
}
$cookie_domain = "." . $domain;

session_set_cookie_params([
    "lifetime" => 0,
    "path" => "/",
    "domain" => $cookie_domain,
    "secure" => isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] !== "off",
    "httponly" => true,
    "samesite" => "Lax"
]);
// Session starten MUSS vor jeder Ausgabe stehen
session_start();

// Buffer leeren für saubere Bildausgabe
if (ob_get_level()) {
    ob_clean();
}

// CAPTCHA-Code generieren - bei jedem Aufruf neu
$captcha_code = "";
$characters = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
for ($i = 0; $i < 5; $i++) {
    $captcha_code .= $characters[rand(0, strlen($characters) - 1)];
}
$_SESSION["captcha_code"] = $captcha_code;

// Bildgröße
$width = 150;
$height = 50;

// HTTP-Header MÜSSEN vor der Bilderstellung gesendet werden
header("Content-Type: image/png");
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
header("Expires: Wed, 1 Jan 1997 00:00:00 GMT");

// Bild erstellen (imagecreatetruecolor für bessere Qualität)
$image = imagecreatetruecolor($width, $height);

// Anti-Aliasing aktivieren
imageantialias($image, true);

// Farben definieren
$bg_color = imagecolorallocate($image, 255, 255, 255);    // Weißer Hintergrund
$text_color = imagecolorallocate($image, 0, 0, 0);        // Schwarzer Text
$noise_color = imagecolorallocate($image, 200, 200, 200); // Hellgrauer Noise
$line_color = imagecolorallocate($image, 150, 150, 150);  // Grauer Linien

// Hintergrund füllen
imagefill($image, 0, 0, $bg_color);

// Störlinien hinzufügen
for ($i = 0; $i < 5; $i++) {
    imageline($image, 
        rand(0, $width), rand(0, $height), 
        rand(0, $width), rand(0, $height), 
        $line_color
    );
}

// Störpunkte hinzufügen
for ($i = 0; $i < 50; $i++) {
    imagesetpixel($image, rand(0, $width), rand(0, $height), $noise_color);
}

// Text zentriert positionieren
$font_size = 5; // Größte verfügbare interne Schrift
$char_width = imagefontwidth($font_size);
$char_height = imagefontheight($font_size);
$total_width = $char_width * strlen($captcha_code);
$start_x = ($width - $total_width) / 2;
$start_y = ($height - $char_height) / 2;

// Zeichen einzeln mit zufälliger Variation rendern
for ($i = 0; $i < strlen($captcha_code); $i++) {
    $char = $captcha_code[$i];
    $x = $start_x + ($i * $char_width) + rand(-2, 2);
    $y = $start_y + rand(-3, 3);
    
    // Zeichen rendern
    imagestring($image, $font_size, $x, $y, $char, $text_color);
}

// PNG ausgeben
imagepng($image);

// Speicher freigeben
imagedestroy($image);

// Script beenden
exit();
?>
