<?php

session_start();


// Anti-Spam: CSRF-Token und Zeitstempel erstellen
if (empty($_SESSION["csrf_token"])) {
    $_SESSION["csrf_token"] = bin2hex(random_bytes(32));
}
$_SESSION["form_start_time"] = time();

?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kontaktformular</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <style>
        body { 
            background-color: #f8f9fa;
            padding: 2rem;
        }
        .container {
            max-width: 600px;
            margin-top: 2rem;
            background: white;
            padding: 2rem;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .form-check {
            margin-bottom: 0.5rem;
        }
        /* Anti-Spam: Honeypot-Feld für Bots verstecken */
        .antispam-honeypot {
            position: absolute;
            left: -9999px;
        }
        /* CAPTCHA Styling */
        .captcha-container {
            display: flex;
            align-items: center;
            gap: 15px;
            margin-bottom: 15px;
        }
        .captcha-image {
            border: 2px solid #dee2e6;
            border-radius: 4px;
            background: #f8f9fa;
        }
        .captcha-refresh {
            cursor: pointer;
            color: #0d6efd;
            font-size: 1.2em;
            transition: color 0.2s;
        }
        .captcha-refresh:hover {
            color: #0a58ca;
        }
        /* Styling für Kopie-Checkbox */
        .copy-checkbox-container {
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            border: 1px solid #dee2e6;
            margin-bottom: 20px;
        }
        .copy-checkbox-container .form-check-label {
            font-size: 0.9em;
            color: #6c757d;
        }
    </style>
    
    <!-- Resize-Skript für ein dynamisches iFrame von Werner Zenk -->
    <script>
        window.addEventListener("load", fenster);
        window.addEventListener("resize", fenster);
        function fenster() {
            if (parent.document.getElementsByTagName("iframe")[0]) {
                parent.document.getElementsByTagName("iframe")[0].style.height = 
                    document.getElementsByTagName("html")[0].offsetHeight + "px";
            }
        }
    </script>
	</head>
<body>
    <div class="container">
        <h2 class="mb-4">Kontaktformular</h2>
        <div id="form-messages" class="alert alert-danger d-none"></div>
        <form id="contact-form" action="send.php" method="POST" enctype="multipart/form-data" novalidate>
            <input type="hidden" name="csrf_token" value="<?php echo $_SESSION["csrf_token"]; ?>">
            <div class="antispam-honeypot">
                <label for="name_hp">Dieses Feld bitte leer lassen:</label>
                <input type="text" id="name_hp" name="name_hp">
            </div>
            
            <div class="row">

            <div class="col-md-12">
                <div class="mb-3">
                    <label for="Marke" class="form-label">Marke</label>
                    <input type="text" class="form-control" id="Marke" name="Marke"  placeholder="">
                    <div class="form-text"></div>
                </div>
            </div>
            <div class="col-md-12">
                <div class="mb-3">
                    <label for="Bild" class="form-label">Bild</label>
                    <input type="file" class="form-control" id="Bild" name="Bild" >
                    <div class="form-text"></div>
                </div>
            </div>
            </div>
            
            <!-- Automatische Kopie-Checkbox (wird bei jedem Formular eingefügt) -->
            <div class="row">
                <div class="col-12">
                    <div class="copy-checkbox-container">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="send_copy_to_sender" value="1" id="send_copy_to_sender">
                            <label class="form-check-label" for="send_copy_to_sender">
                                <i class="bi bi-envelope-check me-2"></i>Kopie an mich senden
                            </label>
                            <div class="form-text">Sie erhalten eine Kopie Ihrer Nachricht an die von Ihnen angegebene E-Mail-Adresse.</div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- CAPTCHA-Bereich -->
            <div class="row">
            </div>
            <button type="submit" class="btn btn-primary">Senden</button>
        </form>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        
        
        document.getElementById("contact-form").addEventListener("submit", async function(event) {
            event.preventDefault();

            const form = event.target;
            const messagesDiv = document.getElementById("form-messages");
            const submitBtn = form.querySelector("button[type='submit']");

            // Resetting
            messagesDiv.classList.add("d-none");
            messagesDiv.innerHTML = "";
            form.querySelectorAll(".is-invalid").forEach(el => el.classList.remove("is-invalid"));
            
            submitBtn.disabled = true;

            const formData = new FormData(form);

            try {
                const response = await fetch(form.action, {
                    method: form.method,
                    body: formData,
					credentials: "same-origin" // <— wichtig!
                });

                const result = await response.json();

                if (result.success) {
                    window.location.href = "success.php";
                } else {
                    messagesDiv.classList.remove("d-none");
                    messagesDiv.innerHTML = result.message || "Es sind Fehler aufgetreten.";
                    
                    if (result.errors) {
                        result.errors.forEach(fieldName => {
                            const field = form.querySelector(`[name="${fieldName}"]`);
                            if (field) {
                                field.classList.add("is-invalid");
                                // Für Checkboxen und Radios, markiere die Gruppe
                                if (field.type === "checkbox" || field.type === "radio") {
                                    const parentDiv = field.closest(".mb-3");
                                    if(parentDiv) {
                                        parentDiv.querySelector("label").classList.add("text-danger");
                                    }
                                }
                            }
                        });
                    }
                    
                    
                    
                    // Bei Fehlern zum Formular-Anker scrollen
                    scrollParentToAnchor();
                }
            } catch (error) {
                messagesDiv.classList.remove("d-none");
                messagesDiv.innerHTML = "Es gab einen unerwarteten Fehler. Bitte versuchen Sie es später erneut.";
                console.error("Fetch Error:", error);
            } finally {
                submitBtn.disabled = false;
            }
        });
    </script>
    
    <!-- Script Sprunganker für die id="myFrame" vom iFrame und die id="Formular" der Mobirise-Sektion -->
    <script>
        function scrollParentToAnchor() {
            try {
                if (window.parent && window.parent !== window) {
                    // IFrame Höhe anpassen
                    var ifr = window.parent.document.getElementById("myFrame");
                    if (ifr) {
                        ifr.style.height = document.documentElement.scrollHeight + "px";
                    }
                    // Zum Anker #Formular scrollen
                    var anchor = window.parent.document.getElementById("Formular");
                    if (anchor) {
                        anchor.scrollIntoView({ behavior: "smooth", block: "start" });
                    }
                }
            } catch (e) {
                console.warn("Scroll zu #Formular nicht möglich:", e);
            }
        }
    </script>
</body>
</html>
