<?php
$styles_file = 'counter_styles.json';

// Lade vorhandene Stile
$current_styles = [];
if (file_exists($styles_file)) {
    $current_styles = json_decode(file_get_contents($styles_file), true);
}

// Wenn Formular gesendet wurde, speichere die neuen Stile
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_styles = [
        'font-family' => $_POST['font-family'] ?? 'Arial, sans-serif',
        'font-size' => $_POST['font-size'] ?? '16px',
        'font-weight' => $_POST['font-weight'] ?? 'normal',
        'color' => $_POST['color'] ?? '#ffffff',
        'background-color' => $_POST['background-color'] ?? '#000000',
        'background-gradient' => $_POST['background-gradient'] ?? '',
        'border' => $_POST['border'] ?? '1px solid #ccc',
        'border-radius' => $_POST['border-radius'] ?? '0px',
        'box-shadow' => $_POST['box-shadow'] ?? 'none',
        'padding' => $_POST['padding'] ?? '10px',
        'margin' => $_POST['margin'] ?? '20px',
        'width' => $_POST['width'] ?? '300px',
        'min-width' => $_POST['min-width'] ?? '250px',
        'max-width' => $_POST['max-width'] ?? 'none',
        'height' => $_POST['height'] ?? 'auto',
        'min-height' => $_POST['min-height'] ?? 'auto',
        'text-align' => $_POST['text-align'] ?? 'left',
        'line-height' => $_POST['line-height'] ?? '1.5',
        'opacity' => $_POST['opacity'] ?? '1',
        'display-type' => $_POST['display-type'] ?? 'block',
        'animation' => $_POST['animation'] ?? 'none'
    ];

    file_put_contents($styles_file, json_encode($new_styles, JSON_PRETTY_PRINT));
    $success_message = 'Einstellungen wurden erfolgreich gespeichert!';
    $current_styles = $new_styles;
}

// Reset-Funktion
if (isset($_POST['reset'])) {
    $default_styles = [
        'font-family' => 'Arial, sans-serif',
        'font-size' => '16px',
        'font-weight' => 'normal',
        'color' => '#ffffff',
        'background-color' => '#000000',
        'background-gradient' => '',
        'border' => '1px solid #ccc',
        'border-radius' => '0px',
        'box-shadow' => 'none',
        'padding' => '10px',
        'margin' => '20px',
        'width' => '300px',
        'min-width' => '250px',
        'max-width' => 'none',
        'height' => 'auto',
        'min-height' => 'auto',
        'text-align' => 'left',
        'line-height' => '1.5',
        'opacity' => '1',
        'display-type' => 'block',
        'animation' => 'none'
    ];
    
    file_put_contents($styles_file, json_encode($default_styles, JSON_PRETTY_PRINT));
    $success_message = 'Einstellungen wurden auf Standard zurückgesetzt!';
    $current_styles = $default_styles;
}
?>

<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Besucherzähler Admin-Panel</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .admin-container {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 15px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
            margin: 30px auto;
            max-width: 1200px;
        }
        .preview-box {
            background: #f8f9fa;
            border: 2px dashed #dee2e6;
            border-radius: 10px;
            padding: 20px;
            min-height: 200px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .form-section {
            background: white;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            margin-bottom: 20px;
        }
        .section-header {
            background: linear-gradient(45deg, #667eea, #764ba2);
            color: white;
            padding: 15px 20px;
            border-radius: 10px 10px 0 0;
            margin: 0;
            font-weight: 600;
        }
        .color-input {
            height: 45px;
            border-radius: 8px;
        }
        .btn-gradient {
            background: linear-gradient(45deg, #667eea, #764ba2);
            border: none;
            border-radius: 8px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
        }
        .btn-gradient:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        .form-control, .form-select {
            border-radius: 8px;
            border: 2px solid #e9ecef;
            transition: all 0.3s ease;
        }
        .form-control:focus, .form-select:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
    </style>
</head>
<body>
    <div class="container-fluid py-4">
        <div class="admin-container">
            <div class="row g-0">
                <!-- Header -->
                <div class="col-12">
                    <div class="text-center py-4 border-bottom">
                        <h1 class="display-4 fw-bold text-primary">
                            <i class="fas fa-cog me-3"></i>Besucherzähler Admin-Panel
                        </h1>
                        <p class="lead text-muted">Passen Sie das Aussehen Ihres Besucherzählers an</p>
                    </div>
                </div>

                <!-- Live Preview -->
                <div class="col-12 col-lg-5">
                    <div class="p-4">
                        <h3 class="h4 mb-3"><i class="fas fa-eye me-2"></i>Live-Vorschau</h3>
                        <div class="preview-box">
                            <div id="counter-preview" style="
                                font-family: <?php echo htmlspecialchars($current_styles['font-family'] ?? 'Arial, sans-serif'); ?>;
                                font-size: <?php echo htmlspecialchars($current_styles['font-size'] ?? '16px'); ?>;
                                font-weight: <?php echo htmlspecialchars($current_styles['font-weight'] ?? 'normal'); ?>;
                                color: <?php echo htmlspecialchars($current_styles['color'] ?? '#ffffff'); ?>;
                                background-color: <?php echo htmlspecialchars($current_styles['background-color'] ?? '#000000'); ?>;
                                background: <?php echo !empty($current_styles['background-gradient']) ? htmlspecialchars($current_styles['background-gradient']) : htmlspecialchars($current_styles['background-color'] ?? '#000000'); ?>;
                                border: <?php echo htmlspecialchars($current_styles['border'] ?? '1px solid #ccc'); ?>;
                                border-radius: <?php echo htmlspecialchars($current_styles['border-radius'] ?? '0px'); ?>;
                                box-shadow: <?php echo htmlspecialchars($current_styles['box-shadow'] ?? 'none'); ?>;
                                padding: <?php echo htmlspecialchars($current_styles['padding'] ?? '10px'); ?>;
                                margin: <?php echo htmlspecialchars($current_styles['margin'] ?? '20px'); ?>;
                                width: <?php echo htmlspecialchars($current_styles['width'] ?? '300px'); ?>;
                                min-width: <?php echo htmlspecialchars($current_styles['min-width'] ?? '250px'); ?>;
                                max-width: <?php echo htmlspecialchars($current_styles['max-width'] ?? 'none'); ?>;
                                height: <?php echo htmlspecialchars($current_styles['height'] ?? 'auto'); ?>;
                                min-height: <?php echo htmlspecialchars($current_styles['min-height'] ?? 'auto'); ?>;
                                text-align: <?php echo htmlspecialchars($current_styles['text-align'] ?? 'left'); ?>;
                                line-height: <?php echo htmlspecialchars($current_styles['line-height'] ?? '1.5'); ?>;
                                opacity: <?php echo htmlspecialchars($current_styles['opacity'] ?? '1'); ?>;
                                display: <?php echo htmlspecialchars($current_styles['display-type'] ?? 'block'); ?>;
                            ">
                                <h4 style="margin: 0 0 10px 0; color: inherit;">Besucherstatistik</h4>
                                <p style="margin: 5px 0; color: inherit;">Besucher online: 3</p>
                                <p style="margin: 5px 0; color: inherit;">Besucher heute: 42</p>
                                <p style="margin: 5px 0; color: inherit;">Besucher diese Woche: 187</p>
                                <p style="margin: 5px 0; color: inherit;">Besucher diesen Monat: 1,024</p>
                                <p style="margin: 5px 0; color: inherit;">Gesamtbesucher: 15,673</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Settings Form -->
                <div class="col-12 col-lg-7">
                    <div class="p-4">
                        <?php if (isset($success_message)): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <i class="fas fa-check-circle me-2"></i><?php echo $success_message; ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>

                        <form method="post" id="stylesForm">
                            <!-- Schrift-Einstellungen -->
                            <div class="form-section">
                                <h3 class="section-header"><i class="fas fa-font me-2"></i>Schrift-Einstellungen</h3>
                                <div class="p-3">
                                    <div class="row g-3">
                                        <div class="col-md-6">
                                            <label class="form-label fw-bold">Schriftart</label>
                                            <select class="form-select" name="font-family" onchange="updatePreview()">
                                                <option value="Arial, sans-serif" <?php echo ($current_styles['font-family'] ?? '') == 'Arial, sans-serif' ? 'selected' : ''; ?>>Arial</option>
                                                <option value="'Times New Roman', serif" <?php echo ($current_styles['font-family'] ?? '') == "'Times New Roman', serif" ? 'selected' : ''; ?>>Times New Roman</option>
                                                <option value="'Courier New', monospace" <?php echo ($current_styles['font-family'] ?? '') == "'Courier New', monospace" ? 'selected' : ''; ?>>Courier New</option>
                                                <option value="Georgia, serif" <?php echo ($current_styles['font-family'] ?? '') == 'Georgia, serif' ? 'selected' : ''; ?>>Georgia</option>
                                                <option value="Verdana, sans-serif" <?php echo ($current_styles['font-family'] ?? '') == 'Verdana, sans-serif' ? 'selected' : ''; ?>>Verdana</option>
                                                <option value="'Comic Sans MS', cursive" <?php echo ($current_styles['font-family'] ?? '') == "'Comic Sans MS', cursive" ? 'selected' : ''; ?>>Comic Sans MS</option>
                                            </select>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label fw-bold">Schriftgröße</label>
                                            <input type="text" class="form-control" name="font-size" value="<?php echo htmlspecialchars($current_styles['font-size'] ?? '16px'); ?>" placeholder="z.B. 16px, 1.2em, 120%" onchange="updatePreview()">
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label fw-bold">Schriftstärke</label>
                                            <select class="form-select" name="font-weight" onchange="updatePreview()">
                                                <option value="normal" <?php echo ($current_styles['font-weight'] ?? '') == 'normal' ? 'selected' : ''; ?>>Normal</option>
                                                <option value="bold" <?php echo ($current_styles['font-weight'] ?? '') == 'bold' ? 'selected' : ''; ?>>Fett</option>
                                                <option value="lighter" <?php echo ($current_styles['font-weight'] ?? '') == 'lighter' ? 'selected' : ''; ?>>Dünner</option>
                                                <option value="100" <?php echo ($current_styles['font-weight'] ?? '') == '100' ? 'selected' : ''; ?>>100</option>
                                                <option value="300" <?php echo ($current_styles['font-weight'] ?? '') == '300' ? 'selected' : ''; ?>>300</option>
                                                <option value="500" <?php echo ($current_styles['font-weight'] ?? '') == '500' ? 'selected' : ''; ?>>500</option>
                                                <option value="700" <?php echo ($current_styles['font-weight'] ?? '') == '700' ? 'selected' : ''; ?>>700</option>
                                                <option value="900" <?php echo ($current_styles['font-weight'] ?? '') == '900' ? 'selected' : ''; ?>>900</option>
                                            </select>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label fw-bold">Zeilenhöhe</label>
                                            <input type="text" class="form-control" name="line-height" value="<?php echo htmlspecialchars($current_styles['line-height'] ?? '1.5'); ?>" placeholder="z.B. 1.5, 24px" onchange="updatePreview()">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Farben -->
                            <div class="form-section">
                                <h3 class="section-header"><i class="fas fa-palette me-2"></i>Farben & Hintergrund</h3>
                                <div class="p-3">
                                    <div class="row g-3">
                                        <div class="col-md-6">
                                            <label class="form-label fw-bold">Textfarbe</label>
                                            <input type="color" class="form-control color-input" name="color" value="<?php echo htmlspecialchars($current_styles['color'] ?? '#ffffff'); ?>" onchange="updatePreview()">
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label fw-bold">Hintergrundfarbe</label>
                                            <input type="color" class="form-control color-input" name="background-color" value="<?php echo htmlspecialchars($current_styles['background-color'] ?? '#000000'); ?>" onchange="updatePreview()">
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label fw-bold">Gradient Hintergrund (optional)</label>
                                            <input type="text" class="form-control" name="background-gradient" value="<?php echo htmlspecialchars($current_styles['background-gradient'] ?? ''); ?>" placeholder="z.B. linear-gradient(45deg, #ff6b6b, #4ecdc4)" onchange="updatePreview()">
                                            <small class="form-text text-muted">Leer lassen für einfarbigen Hintergrund</small>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label fw-bold">Transparenz</label>
                                            <input type="range" class="form-range" name="opacity" min="0" max="1" step="0.1" value="<?php echo htmlspecialchars($current_styles['opacity'] ?? '1'); ?>" oninput="updatePreview(); this.nextElementSibling.textContent = this.value">
                                            <span><?php echo htmlspecialchars($current_styles['opacity'] ?? '1'); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Layout & Größe -->
                            <div class="form-section">
                                <h3 class="section-header"><i class="fas fa-expand-arrows-alt me-2"></i>Layout & Größe</h3>
                                <div class="p-3">
                                    <div class="row g-3">
                                        <div class="col-md-4">
                                            <label class="form-label fw-bold">Breite</label>
                                            <input type="text" class="form-control" name="width" value="<?php echo htmlspecialchars($current_styles['width'] ?? '300px'); ?>" placeholder="z.B. 300px, 50%, auto" onchange="updatePreview()">
                                        </div>
                                        <div class="col-md-4">
                                            <label class="form-label fw-bold">Min-Breite</label>
                                            <input type="text" class="form-control" name="min-width" value="<?php echo htmlspecialchars($current_styles['min-width'] ?? '250px'); ?>" placeholder="z.B. 250px" onchange="updatePreview()">
                                        </div>
                                        <div class="col-md-4">
                                            <label class="form-label fw-bold">Max-Breite</label>
                                            <input type="text" class="form-control" name="max-width" value="<?php echo htmlspecialchars($current_styles['max-width'] ?? 'none'); ?>" placeholder="z.B. 500px, none" onchange="updatePreview()">
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label fw-bold">Höhe</label>
                                            <input type="text" class="form-control" name="height" value="<?php echo htmlspecialchars($current_styles['height'] ?? 'auto'); ?>" placeholder="z.B. auto, 200px" onchange="updatePreview()">
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label fw-bold">Min-Höhe</label>
                                            <input type="text" class="form-control" name="min-height" value="<?php echo htmlspecialchars($current_styles['min-height'] ?? 'auto'); ?>" placeholder="z.B. auto, 150px" onchange="updatePreview()">
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label fw-bold">Textausrichtung</label>
                                            <select class="form-select" name="text-align" onchange="updatePreview()">
                                                <option value="left" <?php echo ($current_styles['text-align'] ?? '') == 'left' ? 'selected' : ''; ?>>Links</option>
                                                <option value="center" <?php echo ($current_styles['text-align'] ?? '') == 'center' ? 'selected' : ''; ?>>Zentriert</option>
                                                <option value="right" <?php echo ($current_styles['text-align'] ?? '') == 'right' ? 'selected' : ''; ?>>Rechts</option>
                                            </select>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label fw-bold">Display-Typ</label>
                                            <select class="form-select" name="display-type" onchange="updatePreview()">
                                                <option value="block" <?php echo ($current_styles['display-type'] ?? '') == 'block' ? 'selected' : ''; ?>>Block</option>
                                                <option value="inline-block" <?php echo ($current_styles['display-type'] ?? '') == 'inline-block' ? 'selected' : ''; ?>>Inline-Block</option>
                                                <option value="inline" <?php echo ($current_styles['display-type'] ?? '') == 'inline' ? 'selected' : ''; ?>>Inline</option>
                                                <option value="flex" <?php echo ($current_styles['display-type'] ?? '') == 'flex' ? 'selected' : ''; ?>>Flex</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Rahmen & Abstände -->
                            <div class="form-section">
                                <h3 class="section-header"><i class="fas fa-border-all me-2"></i>Rahmen & Abstände</h3>
                                <div class="p-3">
                                    <div class="row g-3">
                                        <div class="col-md-6">
                                            <label class="form-label fw-bold">Rahmen</label>
                                            <input type="text" class="form-control" name="border" value="<?php echo htmlspecialchars($current_styles['border'] ?? '1px solid #ccc'); ?>" placeholder="z.B. 1px solid #ccc" onchange="updatePreview()">
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label fw-bold">Rundung</label>
                                            <input type="text" class="form-control" name="border-radius" value="<?php echo htmlspecialchars($current_styles['border-radius'] ?? '0px'); ?>" placeholder="z.B. 10px" onchange="updatePreview()">
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label fw-bold">Innenabstand</label>
                                            <input type="text" class="form-control" name="padding" value="<?php echo htmlspecialchars($current_styles['padding'] ?? '10px'); ?>" placeholder="z.B. 10px, 5px 10px" onchange="updatePreview()">
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label fw-bold">Außenabstand</label>
                                            <input type="text" class="form-control" name="margin" value="<?php echo htmlspecialchars($current_styles['margin'] ?? '20px'); ?>" placeholder="z.B. 20px, 10px auto" onchange="updatePreview()">
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label fw-bold">Schatten</label>
                                            <input type="text" class="form-control" name="box-shadow" value="<?php echo htmlspecialchars($current_styles['box-shadow'] ?? 'none'); ?>" placeholder="z.B. 0 2px 10px rgba(0,0,0,0.1)" onchange="updatePreview()">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Aktions-Buttons -->
                            <div class="form-section">
                                <div class="p-3">
                                    <div class="row g-3">
                                        <div class="col-md-6">
                                            <button type="submit" class="btn btn-gradient btn-lg w-100 text-white">
                                                <i class="fas fa-save me-2"></i>Einstellungen Speichern
                                            </button>
                                        </div>
                                        <div class="col-md-6">
                                            <button type="submit" name="reset" class="btn btn-outline-secondary btn-lg w-100" onclick="return confirm('Sind Sie sicher, dass Sie alle Einstellungen zurücksetzen möchten?')">
                                                <i class="fas fa-undo me-2"></i>Zurücksetzen
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
    <script>
        function updatePreview() {
            const form = document.getElementById('stylesForm');
            const preview = document.getElementById('counter-preview');
            const formData = new FormData(form);
            
            const styles = {
                'font-family': formData.get('font-family'),
                'font-size': formData.get('font-size'),
                'font-weight': formData.get('font-weight'),
                'color': formData.get('color'),
                'background-color': formData.get('background-color'),
                'background': formData.get('background-gradient') || formData.get('background-color'),
                'border': formData.get('border'),
                'border-radius': formData.get('border-radius'),
                'box-shadow': formData.get('box-shadow'),
                'padding': formData.get('padding'),
                'margin': formData.get('margin'),
                'width': formData.get('width'),
                'min-width': formData.get('min-width'),
                'max-width': formData.get('max-width'),
                'height': formData.get('height'),
                'min-height': formData.get('min-height'),
                'text-align': formData.get('text-align'),
                'line-height': formData.get('line-height'),
                'opacity': formData.get('opacity'),
                'display': formData.get('display-type')
            };
            
            let cssText = '';
            for (const [property, value] of Object.entries(styles)) {
                if (value && value !== 'none' && value !== 'auto') {
                    cssText += `${property}: ${value}; `;
                }
            }
            
            preview.style.cssText = cssText;
        }
        
        // Event listeners für alle Input-Elemente
        document.addEventListener('DOMContentLoaded', function() {
            const inputs = document.querySelectorAll('input, select');
            inputs.forEach(input => {
                input.addEventListener('input', updatePreview);
                input.addEventListener('change', updatePreview);
            });
        });
    </script>
</body>
</html>