<?php

/**
 * Konfigurationsdatei für Kommentarsystem
 */

// Admin-Zugangsdaten
define('ADMIN_EMAIL', 'deine email.de');
define('ADMIN_PASSWORT', 'dein passwort');  // Klartext-Passwort (für Kompatibilität)

// SMTP-Konfiguration (nur nötig wenn dein Provider kein mail() unterstützt)
// Entferne die // um SMTP zu aktivieren und passe die Werte an
// define('SMTP_HOST', 'smtp.deinprovider.de');  // z.B. smtp.gmail.com, smtp.strato.de
// define('SMTP_USER', 'dein-username');
// define('SMTP_PASS', 'dein-passwort');
// define('SMTP_PORT', 587);  // 587 für TLS, 465 für SSL

// Email-Benachrichtigungen
define('EMAIL_ENABLED', true);  // false = keine Emails

// Sicherheit
define('SALT', 'aendere_diesen_salt_bitte_vna2024');  // Zufälligen String für IP-Hashing

// Rate Limiting
define('MAX_COMMENTS_PER_TIME', 3);   // Max Kommentare
define('RATE_LIMIT_MINUTES', 10);     // Zeitfenster in Minuten

// Spam-Schutz
define('MIN_SUBMIT_TIME', 3);         // Min. Sekunden zum Ausfüllen
define('MAX_FORM_AGE', 3600);         // Max. Alter des Formulars in Sekunden

// Text-Limits
define('MIN_COMMENT_LENGTH', 10);     // Min. Zeichenlänge
define('MAX_COMMENT_LENGTH', 2000);   // Max. Zeichenlänge
define('MAX_NAME_LENGTH', 50);        // Max. Name-Länge

// Zusätzliche Spam-Keywords (werden zu den Standard-Keywords hinzugefügt)
$customSpamKeywords = [
    // 'dein-keyword',
];

// Blockierte Länder-Domains (TLDs)
$blockedTLDs = [
    '.ru', '.cn', '.tk', '.ml', '.ga', '.cf', '.gq',
    '.pw', '.cc', '.top', '.xyz', '.loan', '.work',
    '.москва', '.рф',  // Kyrillische Domains
];

// Blockierte Länder (nach Accept-Language Header)
// Achtung: Nicht 100% zuverlässig, VPNs können das umgehen
$blockedCountries = [
    'ru',  // Russland
    'cn',  // China  
    'by',  // Belarus
    'kz',  // Kasachstan
    // 'ua',  // Ukraine (auskommentiert als Beispiel)
];

// Kyrillische/Chinesische Zeichen blocken?
define('BLOCK_NON_LATIN', true);  // true = nur lateinische Zeichen erlaubt
?>