<?php
session_start();

$basis = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\') . '/';

header('Content-Type: text/html; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

/* ==========================================================
   CSRF – IMMER neu (entscheidend für Modal / iframe!)
   ========================================================== */
$_SESSION['csrf_token'] = bin2hex(random_bytes(32));

/* ==========================================================
   DB
   ========================================================== */
try {
    $db = new PDO("sqlite:" . __DIR__ . "/db.sqlite");
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $db->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch (Exception $e) {
    die('<div class="error-box">Datenbankfehler – bitte später erneut versuchen.</div>');
}

$ziel    = filter_input(INPUT_GET, 'ziel', FILTER_SANITIZE_SPECIAL_CHARS) ?? 'allgemein';
$version = filter_input(INPUT_GET, 'version', FILTER_SANITIZE_SPECIAL_CHARS) ?? '';
$isAdmin = isset($_SESSION['admin']);

/* ==========================================================
   Kommentare laden
   ========================================================== */
$stmt = $db->prepare("
    SELECT * FROM kommentare
    WHERE ziel = ? AND parent_id IS NULL
    ORDER BY zeit DESC
");
$stmt->execute([$ziel]);
$kommentare = $stmt->fetchAll();

/* ==========================================================
   Datum hübsch
   ========================================================== */
function deutschesDatum($datetime) {
    $ts = strtotime($datetime);
    if (!$ts) return htmlspecialchars($datetime);
    return date('d.m.Y H:i', $ts) . ' Uhr';
}

$returnUrl = $basis . 'kommentar.php?ziel=' . rawurlencode($ziel)
           . ($version ? '&version=' . rawurlencode($version) : '');
?>
<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
html, body {
    margin: 0;
    padding: 0;
    height: 100%;
    overflow: hidden; /* Scroll NICHT hier */
    background: #fff;
}
/* verhindert Überlaufen im Modal */
.kommentar-fragment *,
.kommentar-fragment *::before,
.kommentar-fragment *::after {
    box-sizing: border-box;
}
.kommentar-fragment {
    font-family: Arial, Helvetica, sans-serif;
    max-width: 800px;
    margin: 0 auto;
    padding: 20px;

    height: 100vh;
    overflow-y: auto;
    overflow-x: hidden;   /* ✅ Sicherheit */

    box-sizing: border-box; /* 🔑 entscheidet alles */
}

.kommentar-box {
    border: 1px solid #ddd;
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 15px;
}
.kommentar-author {
    display: flex;
    align-items: center;
    gap: 8px;
    font-weight: bold;
}

/* Grund-Icon */
.user-icon {
    font-size: 1.4em;      /* 👈 größer als Text */
    line-height: 1;
    display: inline-block;
}

/* normaler User */
.is-user .user-icon {
    color: #000;
}

/* Admin */
.is-admin .user-icon {
    color: #007bff;
}
.kommentar-zeit { font-size: .85em; opacity:.6; }
.antwort {
    margin-top: 10px;
    margin-left: 20px;
    padding-left: 12px;
    border-left: 3px solid #007bff;
}
.error-box {
    background:#f8d7da;
    border:1px solid #f5c6cb;
    color:#721c24;
    padding:12px;
    border-radius:8px;
    margin-bottom:15px;
}
input, textarea {
    width:100%;
    padding:10px;
    border-radius:8px;
    border:1px solid #ccc;
    font-family:inherit;
}
.char-counter {
    font-size: 0.8em;
    text-align: right;
    margin-top: 4px;
    opacity: 0.6;
}

.char-counter.warn {
    color: #ffc107;
}

.char-counter.limit {
    color: #dc3545;
    font-weight: bold;
}
.kommentar-author {
    display: flex;
    align-items: center;
    gap: 8px;
    font-weight: bold;
}

.avatar {
    width: 28px;
    height: 28px;
    border-radius: 50%;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    font-size: 14px;
}

/* normale User */
.is-user .avatar {
    background: #333;
    color: #fff;
}



textarea { min-height:120px; }
button {
    margin-top:10px;
    padding:10px 18px;
    border-radius:8px;
    border:none;
    background:#007bff;
    color:#fff;
    cursor:pointer;
}
button:disabled { opacity:.6; cursor:not-allowed; }
.hp-field { display:none; }
</style>
</head>
<body>

<div class="kommentar-fragment">

<!-- 🔔 FEHLERMELDUNG AUS speichern.php -->
<?php if (!empty($_SESSION['kommentar_error'])): ?>
    <div class="error-box">
        <?= htmlspecialchars($_SESSION['kommentar_error']) ?>
    </div>
    <?php unset($_SESSION['kommentar_error']); ?>
<?php endif; ?>

<h3>Kommentare <?= $version ? htmlspecialchars($version) : '' ?></h3>
<p><strong>Betreff:</strong> <?= htmlspecialchars($ziel) ?></p>

<?php if (!$kommentare): ?>
    <p>Noch keine Kommentare.</p>
<?php endif; ?>

<?php foreach ($kommentare as $k): ?>
    <div class="kommentar-box">
    <div class="kommentar-author <?= $k['name'] === 'Admin' ? 'is-admin' : 'is-user' ?>">
    <span class="user-icon">👤</span>
    <?= htmlspecialchars($k['name'] ?: 'Anonym') ?>
</div>

        <div><?= nl2br(htmlspecialchars($k['text'])) ?></div>

        <div class="kommentar-zeit">
            <?= deutschesDatum($k['zeit']) ?>
        </div>

        <?php
        $a = $db->prepare("SELECT * FROM kommentare WHERE parent_id = ? ORDER BY zeit ASC");
        $a->execute([$k['id']]);
        foreach ($a->fetchAll() as $ant):
        ?>
            <div class="antwort">
                <strong>Admin:</strong><br>
                <?= nl2br(htmlspecialchars($ant['text'])) ?><br>
                <span class="kommentar-zeit"><?= deutschesDatum($ant['zeit']) ?></span>
            </div>
        <?php endforeach; ?>

<?php if ($isAdmin): ?>
    <form method="post"
          action="<?= htmlspecialchars($basis) ?>antworten.php"
          style="margin-top:12px">

        <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
        <input type="hidden" name="parent_id" value="<?= (int)$k['id'] ?>">
        <input type="hidden" name="ziel" value="<?= htmlspecialchars($ziel) ?>">
        <input type="hidden" name="version" value="<?= htmlspecialchars($version) ?>">

        <textarea name="text"
                  required
                  placeholder="Admin-Antwort schreiben…"
                  style="min-height:80px"></textarea>

        <button type="submit" style="background:#28a745">
            💬 Antworten
        </button>
    </form>
<?php endif; ?>


        <!-- 🗑️ ADMIN-TOOLS -->
        <?php if ($isAdmin): ?>
            <form method="post"
                  action="<?= htmlspecialchars($basis) ?>loeschen.php"
                  onsubmit="return confirm('Diesen Kommentar inkl. Antworten wirklich löschen?');"
                  style="margin-top:10px">

                <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
                <input type="hidden" name="id" value="<?= (int)$k['id'] ?>">
                <input type="hidden" name="ziel" value="<?= htmlspecialchars($ziel) ?>">
                <input type="hidden" name="version" value="<?= htmlspecialchars($version) ?>">

                <button type="submit" style="background:#dc3545">
                    🗑️ Kommentar löschen
                </button>
            </form>
        <?php endif; ?>
    </div>
<?php endforeach; ?>


<hr>

<form method="post" action="<?= htmlspecialchars($basis) ?>speichern.php">
    <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
    <input type="hidden" name="ziel" value="<?= htmlspecialchars($ziel) ?>">
    <input type="hidden" name="version" value="<?= htmlspecialchars($version) ?>">
    <input type="hidden" name="form_time" value="<?= time() ?>">

    <!-- Honeypots -->
    <input type="text" name="website" class="hp-field">
    <input type="email" name="email" class="hp-field">
    <input type="text" name="url" class="hp-field">

    <input type="text" name="name" placeholder="Dein Name (optional)">
    <textarea name="text"
          id="commentText"
          required
          minlength="10"
          maxlength="2000"
          placeholder="Dein Kommentar..."></textarea>

<div class="char-counter" id="charCounter">0 / 2000 Zeichen</div>


    <button type="submit">Kommentar senden</button>
</form>

<?php if ($isAdmin): ?>
    <p><a href="<?= htmlspecialchars($basis) ?>logout.php?return=<?= rawurlencode($returnUrl) ?>">Admin Logout</a></p>
<?php else: ?>
    <p><a href="<?= htmlspecialchars($basis) ?>login.php?return=<?= rawurlencode($returnUrl) ?>">Admin Login</a></p>
<?php endif; ?>

</div>
<script>
const textarea = document.getElementById('commentText');
const counter  = document.getElementById('charCounter');
const max      = 2000;

if (textarea && counter) {
    textarea.addEventListener('input', () => {
        const len = textarea.value.length;
        counter.textContent = `${len} / ${max} Zeichen`;

        counter.classList.remove('warn', 'limit');

        if (len > max * 0.85) counter.classList.add('warn');
        if (len >= max) counter.classList.add('limit');
    });
}
</script>

</body>
</html>
