<?php
session_start();

/**
 * Admin-Login für Kommentarsystem
 */

$basis = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\') . '/';

// Konfiguration laden
if (file_exists(__DIR__ . '/config.php')) {
    require_once __DIR__ . '/config.php';
} else {
    die('Konfigurationsdatei nicht gefunden!');
}

$error = '';
$returnUrl = $_GET['return'] ?? $basis . 'kommentar.php';

// Login verarbeiten
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $password = $_POST['password'] ?? '';
    
    // Rate Limiting: Max 5 Versuche in 15 Minuten
    if (!isset($_SESSION['login_attempts'])) {
        $_SESSION['login_attempts'] = 0;
        $_SESSION['login_first_attempt'] = time();
    }
    
    $timeDiff = time() - $_SESSION['login_first_attempt'];
    
    if ($_SESSION['login_attempts'] >= 5 && $timeDiff < 900) {
        $waitMinutes = ceil((900 - $timeDiff) / 60);
        $error = "Zu viele Login-Versuche. Bitte warte noch {$waitMinutes} Minute(n).";
    } elseif ($timeDiff >= 900) {
        // Reset nach 15 Minuten
        $_SESSION['login_attempts'] = 0;
        $_SESSION['login_first_attempt'] = time();
    }
    
    if (empty($error)) {
        if (defined('ADMIN_PASSWORT') && $password === ADMIN_PASSWORT) {
            $_SESSION['admin'] = true;
            $_SESSION['login_attempts'] = 0;
            header('Location: ' . $returnUrl);
            exit;
        } else {
            $_SESSION['login_attempts']++;
            $error = 'Falsches Passwort!';
            sleep(2); // Schutz gegen Brute-Force
        }
    }
}

// Wenn bereits eingeloggt
if (isset($_SESSION['admin'])) {
    header('Location: ' . $returnUrl);
    exit;
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .login-container {
            background: white;
            padding: 40px;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,.3);
            max-width: 400px;
            width: 100%;
            animation: slideUp 0.4s ease;
        }
        
        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        h2 {
            margin-bottom: 10px;
            color: #333;
            font-size: 1.8rem;
        }
        
        .subtitle {
            color: #666;
            margin-bottom: 30px;
            font-size: 0.9rem;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            color: #555;
            font-weight: 500;
        }
        
        input[type="password"] {
            width: 100%;
            padding: 12px 16px;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            font-size: 1rem;
            transition: border-color 0.3s ease;
        }
        
        input[type="password"]:focus {
            outline: none;
            border-color: #667eea;
        }
        
        button {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s ease, box-shadow 0.2s ease;
        }
        
        button:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(102, 126, 234, 0.4);
        }
        
        button:active {
            transform: translateY(0);
        }
        
        .error {
            background: #fee;
            color: #c33;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            border-left: 4px solid #c33;
            font-size: 0.9rem;
        }
        
        .back-link {
            text-align: center;
            margin-top: 20px;
        }
        
        .back-link a {
            color: #667eea;
            text-decoration: none;
            font-size: 0.9rem;
        }
        
        .back-link a:hover {
            text-decoration: underline;
        }
        
        .lock-icon {
            font-size: 3rem;
            text-align: center;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="lock-icon">🔐</div>
        <h2>Admin Login</h2>
        <p class="subtitle">Kommentarsystem Verwaltung</p>
        
        <?php if ($error): ?>
            <div class="error">
                ⚠️ <?= htmlspecialchars($error) ?>
            </div>
        <?php endif; ?>
        
        <form method="post" action="">
            <div class="form-group">
                <label for="password">Passwort</label>
                <input 
                    type="password" 
                    id="password" 
                    name="password" 
                    required 
                    autofocus
                    placeholder="Passwort eingeben">
            </div>
            
            <button type="submit">
                🔓 Anmelden
            </button>
        </form>
        
        <div class="back-link">
            <a href="<?= htmlspecialchars($returnUrl) ?>">← Zurück zu den Kommentaren</a>
        </div>
    </div>
</body>
</html>