<?php
session_start();
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/lib/client_factory.php';

//
// Session prüfen
//
if (!isset($_SESSION['fm_host'])) {
    die("Nicht verbunden.");
}

//
// Client laden
//
try {
    $client = fm_get_client();
} catch (Throwable $e) {
    die("Verbindungsfehler: " . htmlspecialchars($e->getMessage()));
}

//
// 1) Parameter lesen
//
$dir = $_GET['dir'] ?? '';
$f   = $_GET['f']   ?? '';

// NEU: Standard-Pfad-Modus (dir + f)
if ($dir !== '' && $f !== '') {
    $path = ($dir === '.' ? $f : $dir . '/' . $f);
}
// ALT: Einfacher "path"-Parameter
else {
    $path = $_GET['path'] ?? '';
}

//
// Kein Pfad = Fehler
//
if ($path === '' || $path === '/') {
    die("Keine Datei angegeben.");
}

//
// Dateiname extrahieren
//
$filename = basename($path);

//
// Datei laden
//
try {
    $data = $client->getFileContents($path);
    if ($data === false || $data === null) {
        die("Datei konnte nicht gelesen werden.");
    }
} catch (Throwable $e) {
    die("Fehler beim Lesen: " . htmlspecialchars($e->getMessage()));
}

//
// Ausgabe-Header
//
header('Content-Description: File Transfer');
header('Content-Type: application/octet-stream');
header('Content-Disposition: attachment; filename="' . $filename . '"');
header('Content-Length: ' . strlen($data));
header('Cache-Control: must-revalidate');
header('Pragma: public');

echo $data;
exit;
