<?php
require_once __DIR__ . '/FtpClient.php';
require_once __DIR__ . '/FtpsClient.php';
require_once __DIR__ . '/SftpClient.php';

/**
 * Erzeugt den passenden Client anhand der Session-Daten.
 */
function fm_get_client()
{
    $host  = $_SESSION['fm_host']  ?? $_SESSION['host']  ?? null;
    $user  = $_SESSION['fm_user']  ?? $_SESSION['user']  ?? null;
    $pass  = $_SESSION['fm_pass']  ?? $_SESSION['pass']  ?? null;
    $proto = $_SESSION['fm_proto'] ?? $_SESSION['proto'] ?? null;
    $port  = $_SESSION['fm_port']  ?? $_SESSION['port']  ?? null;

    if (!$host || !$user || !$pass || !$proto) {
        throw new Exception("Session-Daten fehlen.");
    }

    if (!$port) {
        $port = match ($proto) {
            'ftp'  => 21,
            'ftps' => 21,
            'sftp' => 22,
            default => 21
        };
    }

    return match ($proto) {
        'ftp'  => new FtpClient($host, $user, $pass, $port),
        'ftps' => new FtpsClient($host, $user, $pass, $port),
        'sftp' => new SftpClient($host, $user, $pass, $port),
        default => throw new Exception("Unbekanntes Protokoll: $proto")
    };
}
