<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/config.php';

if (!isset($_SESSION['fm_host'], $_SESSION['fm_user'], $_SESSION['fm_proto'])) {
    header('Location: index.php');
    exit;
}

$cwd = $_GET['dir'] ?? '.';
if ($cwd === '') {
    $cwd = '.';
}

// Sortierung
$sort = $_GET['sort'] ?? 'name';   // name | size | mtime
$dirc = $_GET['dirc'] ?? 'asc';   // asc | desc

try {
    $client = getClient();
    $items  = $client->listDirectory($cwd);
	
	
	
} catch (Exception $e) {
    die('Verbindungsfehler: ' . htmlspecialchars($e->getMessage()));
}

// Items absichern & Default-Werte setzen
foreach ($items as &$it) {
    if (!isset($it['name']))   $it['name']   = '';
    if (!isset($it['is_dir'])) $it['is_dir'] = false;
    if (!isset($it['size']))   $it['size']   = 0;
    if (!isset($it['mtime']))  $it['mtime']  = 0;
}
unset($it);

// Sortierung
usort($items, function ($a, $b) use ($sort, $dirc) {
    $v1 = $a[$sort] ?? ($sort === 'name' ? $a['name'] : 0);
    $v2 = $b[$sort] ?? ($sort === 'name' ? $b['name'] : 0);

    if ($sort === 'size' || $sort === 'mtime') {
        $v1 = (int)$v1;
        $v2 = (int)$v2;
    } else {
        $v1 = (string)$v1;
        $v2 = (string)$v2;
    }

    $cmp = $v1 <=> $v2;
    return $dirc === 'asc' ? $cmp : -$cmp;
});

// Breadcrumbs bauen
$breadcrumbs = [];
if ($cwd !== '.' && $cwd !== '/') {
    $parts = explode('/', trim($cwd, '/'));
    $build = '';
    foreach ($parts as $p) {
        if ($p === '') continue;
        $build .= '/' . $p;
        $breadcrumbs[] = [
            'name' => $p,
            'path' => ltrim($build, '/')
        ];
    }
}

// Hilfsfunktion für Sortier-Links
function sortLink(string $label, string $column, string $cwd, string $currentSort, string $currentDirc): string
{
    $newDirc = ($currentSort === $column && $currentDirc === 'asc') ? 'desc' : 'asc';
    $icon = '';
    if ($currentSort === $column) {
        $icon = $currentDirc === 'asc' ? ' ▲' : ' ▼';
    }
    $url = 'browser.php?dir=' . urlencode($cwd) . '&sort=' . urlencode($column) . '&dirc=' . urlencode($newDirc);
    return '<a href="' . htmlspecialchars($url) . '">' . htmlspecialchars($label) . $icon . '</a>';
}

// Dateityp-Helfer
function fm_ext(string $name): string {
    $pos = strrpos($name, '.');
    if ($pos === false) return '';
    return strtolower(substr($name, $pos + 1));
}

function fm_is_image(string $name): bool {
    return in_array(fm_ext($name), ['jpg','jpeg','png','gif','webp','avif','bmp']);
}

function fm_is_pdf(string $name): bool {
    return fm_ext($name) === 'pdf';
}

function fm_is_text(string $name): bool {
    return in_array(fm_ext($name), ['txt','log','html','htm','css','js','php','md','ini','json','xml']);
}

$host  = $_SESSION['fm_host'];
$user  = $_SESSION['fm_user'];
$proto = strtoupper($_SESSION['fm_proto']);

$msg   = $_GET['msg']   ?? '';
$error = $_GET['error'] ?? '';

?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <title>FTP/SFTP Browser 3.0</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css"
        rel="stylesheet">
    <style>
        body { background: #f5f5f5; }
        .path-bar { font-size: 0.9rem; color: #666; }
        #search { max-width: 260px; }
        #dropzone {
            border: 2px dashed #6c757d;
            border-radius: .5rem;
            padding: 1rem;
            text-align: center;
            cursor: pointer;
            background-color: #fff;
        }
        #dropzone.dragover {
            background-color: #e9f7ff;
        }
        tr.hidden { display: none; }
        .file-icon { font-size: 18px; margin-right: 6px; }
        .thumb {
            max-height: 36px;
            max-width: 64px;
            border-radius: 4px;
            object-fit: cover;
            margin-right: 6px;
        }
        .preview-click {
            cursor: pointer;
        }
    </style>
</head>
<body>

<nav class="navbar navbar-dark bg-dark mb-4">
    <div class="container-fluid">
        <span class="navbar-brand">
            <?=$proto?> – <?=htmlspecialchars($user)?>@<?=htmlspecialchars($host)?>
        </span>
        <a href="index.php" class="btn btn-outline-light btn-sm">Neu verbinden</a>
    </div>
</nav>

<div class="container mb-4">

    <?php if ($msg): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <?=htmlspecialchars($msg)?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if ($error): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <?=htmlspecialchars($error)?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <!-- Kopf: Navigation & Breadcrumb + Suche -->
    <div class="card mb-3">
        <div class="card-body d-flex flex-wrap align-items-center gap-2">

            <?php if ($cwd !== '.' && $cwd !== '/'): ?>
                <a href="browser.php?dir=<?=urlencode(dirname($cwd))?>"
                   class="btn btn-outline-secondary btn-sm">
                    ⬅ Zurück
                </a>
            <?php endif; ?>

            <a href="browser.php?dir=."
               class="btn btn-outline-primary btn-sm">
                🏠 Home
            </a>

            <div class="ms-2 path-bar">
                <strong>Pfad:</strong>
                <a href="browser.php?dir=." class="text-decoration-none">/</a>
                <?php foreach ($breadcrumbs as $crumb): ?>
                    /
                    <a href="browser.php?dir=<?=urlencode($crumb['path'])?>" class="text-decoration-none">
                        <?=htmlspecialchars($crumb['name'])?>
                    </a>
                <?php endforeach; ?>
            </div>

            <div class="ms-auto d-flex align-items-center gap-2 flex-wrap">
                <input id="search" type="text" class="form-control form-control-sm"
                       placeholder="🔍 Live-Suche...">

                <!-- ZIP aktuelles Verzeichnis -->
                <a href="zip_download.php?dir=<?=urlencode($cwd)?>"
                   class="btn btn-sm btn-outline-secondary">
                    ZIP dieses Verzeichnisses
                </a>
<button class="btn btn-danger" onclick="deleteSelected()">
    🗑️ Auswahl löschen
</button>
                <!-- ZIP aus Auswahl -->
                <button type="button"
                        class="btn btn-sm btn-outline-secondary"
                        onclick="bulkZip()">
                    ZIP aus Auswahl
                </button>

                <!-- ZIP hochladen & entpacken -->
                <form class="d-inline-flex align-items-center" method="post" action="unzip.php" enctype="multipart/form-data">
                    <input type="hidden" name="dir" value="<?=htmlspecialchars($cwd)?>">
                    <input type="file" name="zip" accept=".zip"
                           class="form-control form-control-sm" style="max-width:180px;">
                    <button class="btn btn-sm btn-outline-success ms-1">Entpacken</button>
                </form>
            </div>

        </div>
    </div>

    <!-- Aktionen: Ordner, Upload, Drag&Drop -->
    <div class="row g-3 mb-3">
        <!-- Ordner anlegen -->
        <div class="col-md-4">
            <div class="card h-100">
                <div class="card-body">
                    <h6 class="card-title">📁 Ordner anlegen</h6>
                    <form class="d-flex" method="post" action="mkdir.php">
                        <input type="hidden" name="dir" value="<?=htmlspecialchars($cwd)?>">
                        <input type="text" name="name" class="form-control form-control-sm me-2"
                               placeholder="Neuer Ordner">
                        <button class="btn btn-primary btn-sm">OK</button>
                    </form>
                </div>
            </div>
        </div>
<div class="row g-3 mb-3">
<!-- Datei anlegen -->
<div class="col-md-4">
    <div class="card h-100">
        <div class="card-body">
            <h6 class="card-title">📄 Datei erstellen</h6>

            <form class="d-flex" method="post" action="create_file.php">
                <input type="hidden" name="dir" value="<?=htmlspecialchars($cwd)?>">
                <input type="text" name="name" class="form-control form-control-sm me-2"
                       placeholder="Neue Datei (z.B. index.php)" required>
                <button class="btn btn-primary btn-sm">OK</button>
            </form>

        </div>
    </div>
</div>

        <!-- Klassischer Upload -->
        <div class="col-md-4">
            <div class="card h-100">
                <div class="card-body">
                    <h6 class="card-title">⬆ Datei-Upload</h6>
                    <form method="post" action="upload.php" enctype="multipart/form-data">
                        <input type="hidden" name="dir" value="<?=htmlspecialchars($cwd)?>">
                        <input type="file" name="files[]" multiple class="form-control form-control-sm mb-2">
                        <button class="btn btn-success btn-sm w-100">Hochladen</button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Drag & Drop Upload -->
        <div class="col-md-4">
            <div class="card h-100">
                <div class="card-body">
                    <h6 class="card-title">⬆ Drag & Drop</h6>
                    <div id="dropzone">
                        Dateien hierher ziehen<br>
                        <small>(ins aktuelle Verzeichnis)</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Datei-/Ordnerliste -->
    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-striped table-hover align-middle mb-0">
                    <thead class="table-light">
                    <tr>
                        <th style="width:30px;">
                            <input type="checkbox" id="checkAll">
                        </th>
                        <th><?=sortLink('Name', 'name', $cwd, $sort, $dirc)?></th>
                        <th class="text-end"><?=sortLink('Größe', 'size', $cwd, $sort, $dirc)?></th>
                        <th class="text-end"><?=sortLink('Datum', 'mtime', $cwd, $sort, $dirc)?></th>
                        <th class="text-end" style="width:260px;">Aktionen</th>
                    </tr>
                    </thead>
                    <tbody id="fileTable">

                    <?php if ($cwd !== '.' && $cwd !== '/'): ?>
                        <tr data-name="..">
                            <td></td>
                            <td>
                                <a href="browser.php?dir=<?= urlencode(dirname($cwd)) ?>">
                🔙 ..
            </a>
        </td>
        <td class="text-end">-</td>
        <td class="text-end">-</td>
        <td class="text-end"></td>
    </tr>
<?php endif; ?>

<?php foreach ($items as $f): ?>
    <?php
    $name  = $f['name'];
    if ($name === '.' || $name === '..') continue;

    $isDir = !empty($f['is_dir']);
    $size  = (int)($f['size'] ?? 0);
    $mtime = (int)($f['mtime'] ?? 0);
    $fullPath = ($cwd === '.' ? $name : $cwd . '/' . $name);

    $ext = fm_ext($name);
    $isImg = !$isDir && fm_is_image($name);
    $isPdf = !$isDir && fm_is_pdf($name);
    $isTxt = !$isDir && fm_is_text($name);

    // Bearbeitbare Dateien bestimmen
    $editableExt = ['txt','html','htm','css','js','php','ini','log','json','xml','htaccess'];
    $isEditable  = !$isDir && in_array(strtolower($ext), $editableExt);
    ?>
    <tr data-name="<?= htmlspecialchars($name) ?>">
        <td>
            <input type="checkbox" class="chkItem" value="<?= htmlspecialchars($name) ?>">
        </td>

        <td>
            <?php if ($isDir): ?>
                <a href="browser.php?dir=<?= urlencode($fullPath) ?>">
                    📁 <?= htmlspecialchars($name) ?>
                </a>
            <?php else: ?>

                <?php if ($isImg): ?>
                    <img src="preview.php?mode=thumb&dir=<?= urlencode($cwd) ?>&f=<?= urlencode($name) ?>"
                         alt=""
                         class="thumb preview-click"
                         onclick="openPreview('<?= htmlspecialchars($name, ENT_QUOTES) ?>','image')">
                <?php else: ?>
                    <span class="file-icon">
                        <?php if ($isPdf): ?>📄
                        <?php elseif ($isTxt): ?>📃
                        <?php else: ?>📦
                        <?php endif; ?>
                    </span>
                <?php endif; ?>

                <span class="preview-click"
                      onclick="openPreview('<?= htmlspecialchars($name, ENT_QUOTES) ?>',
                        '<?= $isImg?'image':($isPdf?'pdf':($isTxt?'text':'other')) ?>')">
                    <?= htmlspecialchars($name) ?>
                </span>
            <?php endif; ?>
        </td>

        <td class="text-end">
            <?= $isDir ? '-' : ($size > 0 ? number_format($size / 1024, 1, ',', '.') . ' KB' : '-') ?>
        </td>

        <td class="text-end">
            <?= $mtime > 0 ? date('d.m.Y H:i', $mtime) : '-' ?>
        </td>

       <td class="text-end">

    <?php if (!$isDir): ?>
        <a href="download.php?dir=<?= urlencode($cwd) ?>&f=<?= urlencode($name) ?>"
           class="btn btn-sm btn-outline-primary">
            Download
        </a>
    <?php endif; ?>

    <?php if ($isEditable): ?>
        <a href="edit.php?dir=<?= urlencode($cwd) ?>&f=<?= urlencode($name) ?>"
           class="btn btn-sm btn-info">
            Bearbeiten
        </a>
    <?php endif; ?>

    <button type="button"
            class="btn btn-sm btn-secondary"
            onclick="renameItem('<?= htmlspecialchars($name, ENT_QUOTES) ?>')">
        Umbenennen
    </button>

    <button type="button"
            class="btn btn-sm btn-warning"
            onclick="openChmodModal('<?= htmlspecialchars($name, ENT_QUOTES) ?>')">
        Rechte
    </button>

    <a href="delete.php?dir=<?= urlencode($cwd) ?>&f=<?= urlencode($name) ?>"
       class="btn btn-sm btn-danger"
       onclick="return confirm('Wirklich löschen?');">
        Löschen
    </a>

</td>

    </tr>
<?php endforeach; ?>


                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>

<!-- CHMOD Modal -->
<div class="modal fade" id="chmodModal" tabindex="-1" aria-labelledby="chmodModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form class="modal-content" method="post" action="chmod.php">
            <div class="modal-header">
                <h5 class="modal-title" id="chmodModalLabel">Rechte ändern (CHMOD)</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Schließen"></button>
            </div>
            <div class="modal-body">
                <input type="hidden" name="dir" value="<?=htmlspecialchars($cwd)?>">
                <input type="hidden" name="name" id="chmodName">
                <div class="mb-3">
                    <label class="form-label">Datei / Ordner</label>
                    <input type="text" class="form-control" id="chmodNameDisplay" readonly>
                </div>
                <div class="mb-3">
                    <label class="form-label">Modus (z.B. 755, 644)</label>
                    <input type="text" name="mode" class="form-control" placeholder="755" required>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Abbrechen</button>
                <button type="submit" class="btn btn-primary">Speichern</button>
            </div>
        </form>
    </div>
</div>

<!-- Preview Modal -->
<div class="modal fade" id="previewModal" tabindex="-1" aria-labelledby="previewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="previewModalLabel">Vorschau</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Schließen"></button>
            </div>
            <div class="modal-body" id="previewBody" style="min-height:300px;">
                Lade Vorschau...
            </div>
            <div class="modal-footer">
                <a id="previewDownload" href="#" class="btn btn-primary" target="_blank">Download</a>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Schließen</button>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
const currentDir = <?=json_encode($cwd)?>;

// Live-Suche
document.getElementById('search').addEventListener('input', function () {
    const q = this.value.toLowerCase();
    document.querySelectorAll('#fileTable tr').forEach(tr => {
        const name = (tr.getAttribute('data-name') || '').toLowerCase();
        if (!name) return; // z.B. Zurück-Zeile
        tr.classList.toggle('hidden', name.indexOf(q) === -1);
    });
});

// Alle Checkboxen
const checkAll = document.getElementById('checkAll');
if (checkAll) {
    checkAll.addEventListener('change', function() {
        document.querySelectorAll('.chkItem').forEach(ch => {
            ch.checked = checkAll.checked;
        });
    });
}

// Rename
function renameItem(oldName) {
    const newName = prompt('Neuer Name für: ' + oldName, oldName);
    if (!newName || newName === oldName) return;

    const dir = currentDir;
    const url = 'rename.php?dir=' + encodeURIComponent(dir)
        + '&old=' + encodeURIComponent(oldName)
        + '&new=' + encodeURIComponent(newName);

    window.location.href = url;
}

// CHMOD Modal
let chmodModal = null;
function openChmodModal(name) {
    document.getElementById('chmodName').value = name;
    document.getElementById('chmodNameDisplay').value = name;
    if (!chmodModal) {
        chmodModal = new bootstrap.Modal(document.getElementById('chmodModal'));
    }
    chmodModal.show();
}

// Drag & Drop Upload
const dropzone = document.getElementById('dropzone');
dropzone.addEventListener('dragover', e => {
    e.preventDefault();
    dropzone.classList.add('dragover');
});
dropzone.addEventListener('dragleave', e => {
    e.preventDefault();
    dropzone.classList.remove('dragover');
});
dropzone.addEventListener('drop', e => {
    e.preventDefault();
    dropzone.classList.remove('dragover');

    const files = e.dataTransfer.files;
    if (!files.length) return;

    const formData = new FormData();
    formData.append('dir', currentDir);

    for (const f of files) {
        formData.append('files[]', f);
    }

    fetch('upload.php', {
        method: 'POST',
        body: formData
    }).then(() => {
        location.reload();
    }).catch(err => {
        alert('Fehler beim Upload: ' + err);
    });
});

// Bulk ZIP aus Auswahl
function bulkZip() {
    const checked = Array.from(document.querySelectorAll('.chkItem:checked'))
        .map(ch => ch.value);

    if (checked.length === 0) {
        alert('Bitte Dateien/Ordner auswählen.');
        return;
    }

    // Form dynamisch erstellen
    const form = document.createElement('form');
    form.method = 'post';
    form.action = 'zip.php'; // Bulk-ZIP

    const dirInput = document.createElement('input');
    dirInput.type = 'hidden';
    dirInput.name = 'dir';
    dirInput.value = currentDir;
    form.appendChild(dirInput);

    checked.forEach(name => {
        const inp = document.createElement('input');
        inp.type = 'hidden';
        inp.name = 'items[]';
        inp.value = name;
        form.appendChild(inp);
    });

    document.body.appendChild(form);
    form.submit();
}

// Preview/Lightbox
let previewModal = null;
function openPreview(name, type) {
    if (!previewModal) {
        previewModal = new bootstrap.Modal(document.getElementById('previewModal'));
    }

    const title = document.getElementById('previewModalLabel');
    const body = document.getElementById('previewBody');
    const dl   = document.getElementById('previewDownload');

    title.textContent = 'Vorschau: ' + name;
    body.innerHTML = 'Lade Vorschau...';

    const baseParams = 'dir=' + encodeURIComponent(currentDir)
        + '&f=' + encodeURIComponent(name);

    dl.href = 'download.php?' + baseParams;

    // BILD
    if (type === 'image') {
        body.innerHTML = '<img src="preview.php?mode=inline&' + baseParams + '" style="max-width:100%;height:auto;">';
        previewModal.show();
        return;
    }

    // PDF
     if (type === 'pdf') {

        const url = 'preview.php?mode=inline&' + baseParams;

        // Neues Tab öffnen
        window.open(url, "_blank");

        // Modal anzeigen (Info)
        body.innerHTML = `
            <div class="text-center p-5">
                <h4>PDF wurde in einem neuen Tab geöffnet</h4>
                <p>Falls kein Tab geöffnet wurde: bitte Popups erlauben.</p>
            </div>
        `;

        previewModal.show();
        return;
    }


    // TEXT
    if (type === 'text') {
        fetch('preview.php?mode=text&' + baseParams)
            .then(r => r.text())
            .then(t => {
                body.innerHTML = '<pre style="white-space:pre-wrap;">' + t + '</pre>';
                previewModal.show();
            });
        return;
    }

    // other
    body.innerHTML = '<p>Kein Viewer verfügbar. <a href="download.php?' + baseParams + '" target="_blank">Download</a></p>';
    previewModal.show();
}


</script>

</body>
</html>
