<?php
session_start();
require __DIR__ . '/config.php';

if (!isset($_POST['dir'], $_POST['name'])) {
    die("Fehlende Parameter.");
}

$dir  = trim($_POST['dir']);
$name = trim($_POST['name']);

if ($name === '') {
    header("Location: browser.php?dir=" . urlencode($dir) . "&error=" . urlencode("Dateiname fehlt."));
    exit;
}

if (preg_match('/[\/\\\\]/', $name)) {
    header("Location: browser.php?dir=" . urlencode($dir) . "&error=" . urlencode("Der Dateiname darf keine Slash-Zeichen enthalten."));
    exit;
}

$path = ($dir === '.' ? $name : "$dir/$name");

try {
    $client = getClient();

    // Prüfen, ob Datei existiert
    $exists = false;
    foreach ($client->listDirectory($dir) as $item) {
        if ($item['name'] === $name) {
            $exists = true;
            break;
        }
    }

    if ($exists) {
        header("Location: browser.php?dir=" . urlencode($dir) . "&error=" . urlencode("Datei existiert bereits."));
        exit;
    }

    // Leere Datei erzeugen
    $client->putFileContents($path, "");

    header("Location: edit.php?dir=" . urlencode($dir) . "&f=" . urlencode($name));
    exit;

} catch (Throwable $e) {
    header("Location: browser.php?dir=" . urlencode($dir) . "&error=" . urlencode($e->getMessage()));
    exit;
}
