<?php
session_start();
require_once __DIR__ . '/config.php';

if (!isset($_POST['dir'], $_POST['files'])) {
    die("Keine Daten erhalten.");
}

$dir = $_POST['dir'];
$files = $_POST['files'];

try {
    $client = getClient();
} catch (Exception $e) {
    die("Client-Fehler: " . $e->getMessage());
}

foreach ($files as $file) {
    $path = ($dir === '.' ? $file : $dir . '/' . $file);

    $isDir = false;
    try {
        $isDir = $client->isDir($path);
    } catch (Throwable $e) {
        continue;
    }

    try {
        if ($isDir) {
            deleteRecursive($client, $path);
        } else {
            $client->delete($path);
        }
    } catch (Throwable $e) {
        // Fehler ignorieren, weiter löschen
    }
}

header("Location: browser.php?dir=" . urlencode($dir));
exit;


/** 🔥 Rekursives Ordnerlöschen */
function deleteRecursive($client, string $path)
{
    $items = $client->listDirectory($path);

    foreach ($items as $entry) {
        $name = $entry['name'];
        if ($name === '.' || $name === '..') continue;

        $sub = $path . '/' . $name;

        if ($entry['is_dir']) {
            deleteRecursive($client, $sub);
        } else {
            $client->delete($sub);
        }
    }

    $client->deleteDir($path);
}
