<?php
session_start();
require __DIR__ . '/config.php';

$dir  = $_GET['dir'] ?? '.';
$file = $_GET['f']   ?? '';

if ($file === '') {
    die("Keine Datei angegeben.");
}

$path = ($dir === '.' ? $file : "$dir/$file");

try {
    $client  = getClient();
    $content = $client->getFileContents($path);
    if ($content === false) {
        $content = "";
    }
} catch (Throwable $e) {
    die("Fehler beim Laden: " . htmlspecialchars($e->getMessage()));
}

$ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <title>Datei bearbeiten – <?= htmlspecialchars($file) ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- CodeMirror 5 -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.16/codemirror.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.16/theme/material-darker.min.css">

    <style>
        body { background: #f5f5f5; }
        .CodeMirror {
            border: 1px solid #ccc;
            height: 80vh;
            font-size: 14px;
        }
    </style>
</head>
<body>

<div class="container mt-4">
    <h3>📝 Datei bearbeiten: <?= htmlspecialchars($file) ?></h3>

    <form method="post" action="save.php">
        <input type="hidden" name="dir"  value="<?= htmlspecialchars($dir) ?>">
        <input type="hidden" name="file" value="<?= htmlspecialchars($file) ?>">

        <textarea id="editor" name="content"><?= htmlspecialchars($content) ?></textarea>

        <div class="mt-3">
            <button class="btn btn-success">💾 Speichern</button>
            <a href="browser.php?dir=<?= urlencode($dir) ?>" class="btn btn-secondary">Zurück</a>
        </div>
    </form>
</div>

<!-- CodeMirror Scripts -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.16/codemirror.min.js"></script>

<!-- Wichtig für PHP! -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.16/mode/clike/clike.min.js"></script>

<!-- PHP-Mode -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.16/mode/php/php.min.js"></script>

<!-- Andere Modi -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.16/mode/xml/xml.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.16/mode/javascript/javascript.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.16/mode/css/css.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.16/mode/htmlmixed/htmlmixed.min.js"></script>

<script>
// Modus nach Dateityp bestimmen
function detectMode(ext) {
    ext = (ext || "").toLowerCase();

    if (ext === "php")  return "application/x-httpd-php";
    if (ext === "js")   return "javascript";
    if (ext === "css")  return "css";
    if (ext === "html" || ext === "htm") return "htmlmixed";
    if (ext === "json") return "javascript";
    if (ext === "xml")  return "xml";

    return "htmlmixed"; // fallback
}

var editor = CodeMirror.fromTextArea(document.getElementById("editor"), {
    lineNumbers: true,
    theme: "material-darker",
    mode: detectMode(<?= json_encode($ext) ?>),
    indentUnit: 4,
    indentWithTabs: false,
    matchBrackets: true,
    autoCloseBrackets: true
});
</script>

</body>
</html>
