<?php

/**
 * ObjectDigestInfo
 *
 * PHP version 5
 *
 * @author    Jim Wigginton <terrafrost@php.net>
 * @copyright 2016 Jim Wigginton
 * @license   http://www.opensource.org/licenses/mit-license.html  MIT License
 * @link      http://phpseclib.sourceforge.net
 */

declare(strict_types=1);

namespace phpseclib3\File\ASN1\Maps;

use phpseclib3\File\ASN1;

/**
 * ObjectDigestInfo
 *
 * @author  Jim Wigginton <terrafrost@php.net>
 */
abstract class ObjectDigestInfo
{
    public const MAP = [
        'type' => ASN1::TYPE_SEQUENCE,
        'children' => [
            'digestedObjectType' => [
                'type' => ASN1::TYPE_ENUMERATED,
                'children' => [
                    'publicKey',
                    'publicKeyCert',
                    'otherObjectTypes',
                ],
            ],
            'otherObjectTypeID' => [
                'type' => ASN1::TYPE_OBJECT_IDENTIFIER,
                'optiona' => true,
            ],
            'digestAlgorithm' => AlgorithmIdentifier::MAP,
            'objectDigest' => ['type' => ASN1::TYPE_BIT_STRING],
        ],
    ];
}
