<?php
// WICHTIG: Keine Leerzeichen oder Text vor diesem PHP-Tag!

session_start();

// Fehler NICHT im Browser ausgeben (PDF würde kaputt gehen)
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);

require_once __DIR__ . '/config.php';

// Parameter einlesen
$mode = $_GET['mode'] ?? 'inline';
$dir  = $_GET['dir'] ?? '.';
$file = $_GET['f'] ?? '';

if ($file === '') {
    http_response_code(400);
    echo "Keine Datei angegeben.";
    exit;
}

// Client holen
try {
    $client = getClient();
} catch (Throwable $e) {
    http_response_code(500);
    echo "Client-Fehler.";
    exit;
}

// Pfad bestimmen
$path = ($dir === '.' || $dir === '' ? $file : rtrim($dir, '/') . '/' . $file);

// Datei laden
$data = $client->getFileContents($path);
if ($data === false || $data === null) {
    http_response_code(404);
    echo "Datei nicht gefunden: " . htmlspecialchars($path);
    exit;
}

$ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));

/* ================= Thumbnail ================= */
if ($mode === 'thumb') {

    if (!in_array($ext, ['jpg','jpeg','png','gif','webp','bmp','avif'])) {
        http_response_code(204); // No Content
        exit;
    }

    $img = @imagecreatefromstring($data);
    if (!$img) {
        header("Content-Type: image/jpeg");
        echo $data;
        exit;
    }

    $w = imagesx($img);
    $h = imagesy($img);
    $maxW = 120;
    $maxH = 90;

    $ratio = min($maxW / $w, $maxH / $h);
    $newW = (int)($w * $ratio);
    $newH = (int)($h * $ratio);

    $thumb = imagecreatetruecolor($newW, $newH);
    imagecopyresampled($thumb, $img, 0, 0, 0, 0, $newW, $newH, $w, $h);

    header("Content-Type: image/jpeg");
    imagejpeg($thumb, null, 80);

    imagedestroy($img);
    imagedestroy($thumb);
    exit;
}

/* ================= Inline-Anzeige ================= */
if ($mode === 'inline') {

    // Bilder
    if (in_array($ext, ['jpg','jpeg','png','gif','webp','bmp','avif'])) {

        $mime = match($ext) {
            'jpg', 'jpeg' => 'image/jpeg',
            'png'         => 'image/png',
            'gif'         => 'image/gif',
            'webp'        => 'image/webp',
            'bmp'         => 'image/bmp',
            'avif'        => 'image/avif',
            default       => 'application/octet-stream',
        };

        header("Content-Type: $mime");
        header("Content-Disposition: inline; filename=\"$file\"");
        echo $data;
        exit;
    }

    // PDF
    if ($ext === 'pdf') {
        header("Content-Type: application/pdf");
        header("Content-Disposition: inline; filename=\"$file\"");
        header("Content-Length: " . strlen($data));
        echo $data;
        exit;
    }

    // andere Dateien als Download-ähnlich anzeigen
    header("Content-Type: application/octet-stream");
    header("Content-Disposition: inline; filename=\"$file\"");
    echo $data;
    exit;
}

/* ================= Textpreview ================= */
if ($mode === 'text') {
    header("Content-Type: text/plain; charset=utf-8");
    echo @mb_convert_encoding($data, 'UTF-8', 'auto');
    exit;
}

/* ================= Fallback ================= */
header("Content-Type: application/octet-stream");
header("Content-Disposition: inline; filename=\"$file\"");
echo $data;
exit;
