<?php
session_start();

require __DIR__ . '/config.php';

if (!isset($_POST['dir']) || !isset($_FILES['zip'])) {
    die("Fehlende Daten.");
}

$dir = $_POST['dir'];
$tmp = $_FILES['zip']['tmp_name'];

$zip = new ZipArchive();
$res = $zip->open($tmp);

if ($res !== TRUE) {
    die("ZIP konnte nicht geöffnet werden (Code: $res)");
}

try {
    $client = getClient();

    for ($i = 0; $i < $zip->numFiles; $i++) {

        $stat = $zip->statIndex($i);
        if (!$stat) continue;

        $path = $stat['name'];

        // Leere Pfade überspringen
        if (trim($path) === '') continue;

        // Zielpfad auf Server
        $remotePath = ($dir === '.' ? $path : $dir . '/' . $path);

        // Ordner?
        if (substr($path, -1) === '/') {

            // rekursiv Ordnerpfade anlegen
            $parts = explode('/', rtrim($path, '/'));
            $build = $dir;

            foreach ($parts as $p) {
                $build .= '/' . $p;
                $client->mkdir($build);
            }

            continue;
        }

        // Datei
        $content = $zip->getFromIndex($i);
        if ($content === false) continue;

        // Ordner der Datei anlegen
        $folder = dirname($remotePath);
        if ($folder !== '.' && $folder !== '') {

            $parts = explode('/', $folder);
            $build = '';

            foreach ($parts as $p) {
                if (trim($p) === '') continue;
                $build .= ($build ? '/' : '') . $p;

                // mkdir ignoriert Fehler, falls bereits vorhanden
                $client->mkdir($build);
            }
        }

        // Datei hochladen
        $client->putFileContents($remotePath, $content);
    }

} catch (Throwable $e) {
    die("Fehler beim Entpacken: " . htmlspecialchars($e->getMessage()));
}

$zip->close();

header("Location: browser.php?dir=" . urlencode($dir) . "&msg=unzip_ok");
exit;
