<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

require_once __DIR__ . '/config.php';

try {
    $client = getClient();
} catch (Exception $e) {
    die("Nicht verbunden: " . $e->getMessage());
}

$dir = $_GET['dir'] ?? '.';
if ($dir === '' || $dir === '/') $dir = '.';

// Verzeichnisinhalt holen
$items = $client->listDirectory($dir);
if (!is_array($items)) {
    die("Konnte Verzeichnis nicht lesen.");
}

// ZIP vorbereiten
$zipPath = tempnam(sys_get_temp_dir(), 'ftpzip_');
$zip = new ZipArchive();
if ($zip->open($zipPath, ZipArchive::OVERWRITE) !== true) {
    die("ZIP konnte nicht erstellt werden.");
}

foreach ($items as $item) {
    $name   = $item['name'];
    $isDir  = $item['is_dir'];

    if ($name === '.' || $name === '..') continue;
    if ($isDir) continue; // keine Ordner

    // Remote Pfad
    $remotePath = ($dir === '.' ? $name : rtrim($dir, '/') . '/' . $name);

    // Dateiinhalt holen
    $data = $client->getFileContents($remotePath);
    if ($data === false || $data === null) {
        continue; // Datei nicht lesbar
    }

    // Datei im ZIP speichern
    $zip->addFromString($name, $data);
}

$zip->close();

$zipName = ($dir === '.' ? 'root' : str_replace('/', '_', $dir)) . '.zip';

// Download-Header
header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="' . $zipName . '"');
header('Content-Length: ' . filesize($zipPath));

readfile($zipPath);
unlink($zipPath);
exit;
