<?php
/**
 * admin.php – Adminbereich Linkliste
 * - Login mit festem Passwort
 * - Pending / Approved anzeigen
 * - Freigeben / Löschen
 * - Kategorie ändern (inkl. neu anlegen)
 * - 2026 Volker Niederastroth
 */

session_start();

/* =========================
   KONFIG
========================= */

define('ADMIN_PASSWORT', 'volker04');
define('DATA_FILE', __DIR__ . '/data.json');

/* =========================
   LOGIN / LOGOUT
========================= */

if (isset($_POST['passwort'])) {
    if ($_POST['passwort'] === ADMIN_PASSWORT) {
        $_SESSION['admin'] = true;
        header('Location: admin.php');
        exit;
    }
    $fehler = 'Falsches Passwort';
}

if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: admin.php');
    exit;
}

/* =========================
   NICHT EINGELOGGT
========================= */

if (!isset($_SESSION['admin'])):
?>
<!doctype html>
<html lang="de">
<head>
<meta charset="utf-8">
<title>Admin Login</title>
<style>
body{font-family:Arial;background:#f4f4f4}
.box{width:320px;margin:120px auto;background:#fff;padding:20px}
</style>
</head>
<body>
<div class="box">
<h3>Admin Login</h3>
<?php if (!empty($fehler)) echo "<p style='color:red'>$fehler</p>"; ?>
<form method="post">
<input type="password" name="passwort" placeholder="Passwort" required>
<br><br>
<button>Login</button>
</form>
</div>
</body>
</html>
<?php
exit;
endif;

/* =========================
   DATEN LADEN
========================= */

if (!file_exists(DATA_FILE)) {
    die('data.json nicht gefunden');
}

$data = json_decode(file_get_contents(DATA_FILE), true);
if (!is_array($data)) {
    die('data.json ist ungültig');
}

/* =========================
   AKTIONEN
========================= */

// Freigeben
if (isset($_GET['approve'])) {
    foreach ($data['links'] as &$l) {
        if ($l['id'] == $_GET['approve']) {
            $l['status'] = 'genehmigt';
        }
    }
}

// Löschen
if (isset($_GET['delete'])) {
    $data['links'] = array_values(array_filter(
        $data['links'],
        fn($l) => $l['id'] != $_GET['delete']
    ));
}

// Kategorie ändern / neu setzen
if (isset($_POST['edit_id'])) {
    $id = (int)$_POST['edit_id'];

    $newCat = trim($_POST['new_category'] ?? '');
    $selectCat = trim($_POST['select_category'] ?? '');

    $finalCat = $newCat ?: $selectCat ?: 'Allgemein';

    foreach ($data['links'] as &$l) {
        if ($l['id'] === $id) {
            $l['category'] = $finalCat;
        }
    }

    if (!in_array($finalCat, $data['categories'])) {
        $data['categories'][] = $finalCat;
    }
}

// Änderungen speichern
file_put_contents(
    DATA_FILE,
    json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)
);

// Neu laden
$data = json_decode(file_get_contents(DATA_FILE), true);

/* =========================
   AUSGABE
========================= */
?>
<!doctype html>
<html lang="de">
<head>
<meta charset="utf-8">
<title>Linkliste Admin</title>
<style>
body{font-family:Arial}
table{width:100%;border-collapse:collapse;margin-top:20px}
th,td{border:1px solid #ccc;padding:8px;vertical-align:top}
th{background:#eee}
.pending{color:#d35400;font-weight:bold}
.approved{color:#27ae60;font-weight:bold}
a.btn{padding:4px 8px;background:#333;color:#fff;text-decoration:none}
a.del{background:#a00}
form{margin-top:5px}
small{color:#666}
</style>
</head>
<body>

<h2>Linkliste – Admin</h2>
<p>
<a href="?logout=1">Logout</a>
</p>

<p><strong>Debug:</strong> <?= count($data['links']) ?> Einträge in data.json</p>

<?php if (empty($data['links'])): ?>
<p>Keine Einträge vorhanden.</p>
<?php else: ?>

<table>
<tr>
<th>Status</th>
<th>Titel / Beschreibung</th>
<th>Kategorie</th>
<th>URL</th>
<th>Aktionen</th>
</tr>

<?php foreach ($data['links'] as $l): ?>
<tr>
<td class="<?= htmlspecialchars($l['status']) ?>">
    <?= htmlspecialchars($l['status']) ?>
</td>

<td>
<strong><?= htmlspecialchars($l['title']) ?></strong><br>
<small><?= htmlspecialchars($l['description']) ?></small><br>
<small>Von: <?= htmlspecialchars($l['submitter']) ?></small>
</td>

<td>
<?= htmlspecialchars($l['category']) ?>

<form method="post">
<input type="hidden" name="edit_id" value="<?= $l['id'] ?>">

<select name="select_category">
<?php foreach ($data['categories'] as $cat): ?>
<option value="<?= htmlspecialchars($cat) ?>"
<?= $cat === $l['category'] ? 'selected' : '' ?>>
<?= htmlspecialchars($cat) ?>
</option>
<?php endforeach; ?>
</select>

<br>
<input type="text" name="new_category" placeholder="oder neue Kategorie">

<br>
<button type="submit">✔ ändern</button>
</form>
</td>

<td>
<a href="<?= htmlspecialchars($l['url']) ?>" target="_blank">öffnen</a>
</td>

<td>
<?php if ($l['status'] === 'pending'): ?>
<a class="btn" href="?approve=<?= $l['id'] ?>">✔ freigeben</a>
<?php endif; ?>
<a class="btn del" href="?delete=<?= $l['id'] ?>" onclick="return confirm('Wirklich löschen?')">✖ löschen</a>
</td>
</tr>
<?php endforeach; ?>

</table>
<?php endif; ?>

</body>
</html>
