<!doctype html>
<html lang="de">
<head>
<meta charset="utf-8">
<title>Linkliste CSS Generator V2</title>

<link rel="stylesheet"
      href="https://fonts.googleapis.com/css?family=Inter|Roboto|Open+Sans|Montserrat|Lato">

<style>
body{font-family:Arial;background:#f4f4f4;margin:0}
.wrapper{display:flex;gap:20px;padding:20px}
.panel{width:360px;background:#fff;padding:15px}
.preview{flex:1;background:#fff;padding:20px}
label{display:block;margin-top:10px;font-weight:bold}
textarea{width:100%;height:180px;margin-top:5px}
hr{margin:15px 0}
</style>

<style id="liveCSS"></style>
</head>

<body>

<div class="wrapper">

<!-- ================= STEUERUNG ================= -->
<div class="panel">
<h3>CSS Generator V2</h3>

<label>Schriftart</label>
<select id="font">
  <option>Inter</option>
  <option>Roboto</option>
  <option>Open Sans</option>
  <option>Montserrat</option>
  <option>Lato</option>
  <option>Arial</option>
</select>

<hr>

<h4>Linkliste</h4>

<label>Link Schriftgröße (px)</label>
<input type="range" id="linkSize" min="12" max="28" value="16">

<label>Linkfarbe</label>
<input type="color" id="linkColor" value="#3366cc">

<label>Link Hover</label>
<input type="color" id="linkHover" value="#000000">

<label>Beschreibung Farbe</label>
<input type="color" id="descColor" value="#666666">

<label>Abstand Links</label>
<input type="range" id="spacing" min="0" max="30" value="10">

<hr>

<h4>Submit</h4>

<label>Formular Breite (px)</label>
<input type="range" id="formWidth" min="300" max="900" value="700">

<label>Input Rahmenfarbe</label>
<input type="color" id="inputBorder" value="#cccccc">

<label>Input Fokusfarbe</label>
<input type="color" id="inputFocus" value="#667eea">

<label>Input Hintergrund</label>
<input type="color" id="inputBg" value="#ffffff">

<label>Radius</label>
<input type="range" id="radius" min="0" max="20" value="6">

<label>Button Hintergrund</label>
<input type="color" id="btnBg" value="#667eea">

<label>Button Hover</label>
<input type="color" id="btnHover" value="#556cd6">

<label>Button Textfarbe</label>
<input type="color" id="btnText" value="#ffffff">

<label>Hinweis Textfarbe</label>
<input type="color" id="noteText" value="#222222">

<label>Hinweis Hintergrund</label>
<input type="color" id="noteBg" value="#eaffea">

<hr>

<h4>CSS AUSGABE</h4>

<label>CSS – Linkliste</label>
<textarea id="cssLinkliste" readonly></textarea>

<label>CSS – Submit</label>
<textarea id="cssSubmit" readonly></textarea>
</div>

<!-- ================= PREVIEW ================= -->
<div class="preview">

<details class="linkliste-kategorie" open>
<summary><strong>PHP</strong> (2)</summary>
<ul>
<li>
<strong><a href="#">Beispiel Link</a></strong>
<small>Kurze Beschreibung des Links</small>
</li>
<li>
<strong><a href="#">Noch ein Link</a></strong>
<small>Weitere Beschreibung</small>
</li>
</ul>
</details>

<div class="linkliste-submit">
<p class="linkliste-hinweis">Beispiel Hinweis</p>

<label>URL</label>
<input>

<label>Beschreibung</label>
<textarea></textarea>

<button>Link einreichen</button>
</div>

</div>
</div>

<script>
function updateCSS(){

const f=document.getElementById('font').value;
const linkSize=document.getElementById('linkSize').value;
const link=document.getElementById('linkColor').value;
const hover=document.getElementById('linkHover').value;
const desc=document.getElementById('descColor').value;
const space=document.getElementById('spacing').value;

const w=document.getElementById('formWidth').value;
const ib=document.getElementById('inputBorder').value;
const ifc=document.getElementById('inputFocus').value;
const ibg=document.getElementById('inputBg').value;
const r=document.getElementById('radius').value;
const bb=document.getElementById('btnBg').value;
const bh=document.getElementById('btnHover').value;
const bt=document.getElementById('btnText').value;
const nt=document.getElementById('noteText').value;
const nb=document.getElementById('noteBg').value;

/* LINKLISTE */
const cssLink=`
/* ===== LINKLISTE ===== */

.linkliste-kategorie{
  font-family:'${f}',sans-serif;
}

.linkliste-kategorie a{
  color:${link};
  font-size:${linkSize}px;
  text-decoration:none;
}

.linkliste-kategorie a:hover{
  color:${hover};
}

.linkliste-kategorie small{
  color:${desc};
}

.linkliste-kategorie li{
  margin-bottom:${space}px;
}
`;

/* SUBMIT */
const cssSubmit=`
/* ===== SUBMIT ===== */

.linkliste-submit{
  max-width:${w}px;
  font-family:'${f}',sans-serif;
  margin-top:2.5rem;
}

.linkliste-submit input,
.linkliste-submit textarea{
  width:100%;
  padding:0.6rem;
  border:1px solid ${ib};
  border-radius:${r}px;
  background:${ibg};
  margin-bottom:1rem;
}

.linkliste-submit input:focus,
.linkliste-submit textarea:focus{
  outline:none;
  border-color:${ifc};
}

.linkliste-submit button{
  background:${bb};
  color:${bt};
  border:none;
  border-radius:${r}px;
  padding:0.6rem 1.4rem;
  cursor:pointer;
}

.linkliste-submit button:hover{
  background:${bh};
}

.linkliste-hinweis{
  background:${nb};
  color:${nt};
  border-left:4px solid ${bb};
  padding:0.8rem 1rem;
  margin-bottom:1.5rem;
}
`;

document.getElementById('cssLinkliste').value=cssLink;
document.getElementById('cssSubmit').value=cssSubmit;
document.getElementById('liveCSS').innerHTML=cssLink+cssSubmit;
}

document.querySelectorAll('input,select').forEach(e=>{
  e.addEventListener('input',updateCSS);
});

updateCSS();
</script>

</body>
</html>
