<?php
/**
 * linkliste.php
 * - Alle Kategorien
 * - Einklappbar per <details>
 * - Include-fähig für Mobirise
 */

require_once __DIR__ . '/api.php';

$data = lade_daten(__DIR__ . '/data.json');

$gruppen = [];

foreach ($data['links'] as $link) {
    if ($link['status'] !== 'genehmigt') continue;

    $kat = $link['category'] ?: 'Allgemein';
    $gruppen[$kat][] = $link;
}

if (empty($gruppen)) {
    echo '<p>Noch keine Links vorhanden.</p>';
    return;
}

foreach ($gruppen as $kategorie => $links):
?>
<details class="linkliste-kategorie">
    <summary>
        <strong><?php echo htmlspecialchars($kategorie); ?></strong>
        (<?php echo count($links); ?>)
    </summary>

    <ul>
    <?php foreach ($links as $link): ?>
        <li>
            <strong>
                <a href="<?php echo htmlspecialchars($link['url']); ?>" target="_blank" rel="noopener">
                    <?php echo htmlspecialchars($link['title']); ?>
                </a>
            </strong>

            <?php if (!empty($link['description'])): ?>
                <br>
                <small><?php echo htmlspecialchars($link['description']); ?></small>
            <?php endif; ?>
        </li>
    <?php endforeach; ?>
    </ul>
</details>
<?php endforeach; ?>
