<?php
/**
 * submit.php – ABSOLUTER Pfad zur API
 * Kein Session, kein JS, include-sicher
 */

// API IMMER ABSOLUT EINBINDEN
require_once $_SERVER['DOCUMENT_ROOT'] . '/linkliste/api.php';

$meldung = '';
$fehler  = '';

/* =========================
   CAPTCHA
========================= */
if (!isset($_POST['captcha_a'], $_POST['captcha_b'])) {
    $a = rand(2, 9);
    $b = rand(2, 9);
} else {
    $a = (int)$_POST['captcha_a'];
    $b = (int)$_POST['captcha_b'];
}

/* =========================
   FORMULAR AUSWERTEN
========================= */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    if ((int)($_POST['captcha'] ?? 0) !== ($a + $b)) {
        $fehler = 'Captcha falsch.';
    } else {

        // HIER MUSS geschrieben werden
        link_hinzufuegen([
            'title'       => trim($_POST['title']),
            'url'         => trim($_POST['url']),
            'description' => trim($_POST['description']),
            'category'    => trim($_POST['category'] ?: 'Allgemein'),
            'submitter'   => trim($_POST['submitter'] ?: 'Anonym')
        ]);

        $meldung = 'Danke! Dein Link wurde eingereicht und wird geprüft.';
    }
}
?>

<div class="linkliste-submit">

<?php if ($fehler): ?>
    <p class="linkliste-hinweis" style="background:#ffecec;border-left-color:#c0392b;">
        <?= htmlspecialchars($fehler) ?>
    </p>
<?php endif; ?>

<?php if ($meldung): ?>
    <p class="linkliste-hinweis">
        <?= htmlspecialchars($meldung) ?>
    </p>
<?php endif; ?>

<form method="post">
    <label>URL *</label>
    <input type="url" name="url" required>

    <label>Titel *</label>
    <input type="text" name="title" required>

    <label>Kategorie</label>
    <input type="text" name="category">

    <label>Beschreibung *</label>
    <textarea name="description" required></textarea>

    <label>Dein Name</label>
    <input type="text" name="submitter">

    <label><?= $a ?> + <?= $b ?> = ?</label>
    <input type="number" name="captcha" required>

    <input type="hidden" name="captcha_a" value="<?= $a ?>">
    <input type="hidden" name="captcha_b" value="<?= $b ?>">

    <button type="submit">Link einreichen</button>
</form>
</div>
