<?php
session_start();
// Live Chat System <c> Volker Niederastroth  Version V1.3 23.10.2025

// === Zugangsdaten ===
$adminUser = 'admin'; // Ändern!
$adminPass = 'admin'; // Ändern!

// === Online-/Offline-Datei ===
$statusFile = __DIR__ . '/admin_status.txt';

// === Status umschalten ===
if (isset($_GET['online'])) {
    file_put_contents($statusFile, 'online');
    header("Location: " . strtok($_SERVER["REQUEST_URI"], '?'));
    exit;
}
if (isset($_GET['offline'])) {
    file_put_contents($statusFile, 'offline');
    header("Location: " . strtok($_SERVER["REQUEST_URI"], '?'));
    exit;
}

// === Login prüfen ===
if (isset($_POST['login'])) {
    if ($_POST['username'] === $adminUser && $_POST['password'] === $adminPass) {
        $_SESSION['chat_admin'] = true;
    } else {
        $error = "Falsche Zugangsdaten!";
    }
}

if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// === Wenn nicht eingeloggt ===
if (!isset($_SESSION['chat_admin'])):
?>
<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="UTF-8">
<title>Admin Login</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light d-flex align-items-center justify-content-center vh-100">
  <div class="card shadow-lg p-4" style="width: 22rem;">
    <h3 class="text-center text-success mb-3">💬 Livechat Login</h3>
    <?php if (isset($error)) echo "<div class='alert alert-danger py-2'>$error</div>"; ?>
    <form method="post">
      <div class="mb-3">
        <input type="text" name="username" class="form-control" placeholder="Benutzername" required>
      </div>
      <div class="mb-3">
        <input type="password" name="password" class="form-control" placeholder="Passwort" required>
      </div>
      <button type="submit" name="login" class="btn btn-success w-100">Anmelden</button>
    </form>
  </div>
</body>
</html>
<?php
exit;
endif;
?>
<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="UTF-8">
<title>Livechat Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { height: 100vh; overflow: hidden; }
#chatbox { height: calc(100vh - 240px); overflow-y: auto; border: 1px solid #ddd; padding: 10px; background: #fff; }
.session-item { cursor: pointer; padding: .5rem; border-radius: .25rem; }
.session-item:hover { background-color: #f1f1f1; }
.session-item.active { background-color: #d9fdd3; font-weight: 600; }
#soundBar { display:none; position:fixed; top:0; left:0; right:0; z-index:2000; }
</style>
</head>
<body>

<!-- === Hinweisleiste für Sound + Benachrichtigung === -->
<div id="soundBar" class="alert alert-success text-center mb-0 rounded-0">
  🔔 Sound & Desktop-Benachrichtigungen aktivieren
  <button class="btn btn-sm btn-light ms-3" onclick="enableNotifications()">OK</button>
</div>

<div class="container-fluid h-100">
  <div class="row h-100">
    <!-- Sidebar -->
    <div class="col-3 col-lg-2 border-end bg-light p-3">
      <h5 class="text-success">Aktive Chats</h5>
      <div id="sessionList" class="mb-3"></div>
      <h6>Status</h6>
      <div id="statusBox" class="mb-3 small">
        <?php
          $status = file_exists($statusFile) ? trim(file_get_contents($statusFile)) : 'offline';
          $color = ($status === 'online') ? 'success' : 'danger';
          echo "<p>Aktuell: <span class='badge bg-$color'>$status</span></p>";
        ?>
        <div class="d-grid gap-2">
          <a href="?online=1" class="btn btn-sm btn-success">Online setzen</a>
          <a href="?offline=1" class="btn btn-sm btn-secondary">Offline setzen</a>
        </div>
      </div>
      <a href="?logout=1" class="btn btn-outline-danger btn-sm w-100">Logout</a>
    </div>

    <!-- Chat-Bereich -->
    <div class="col-9 col-lg-10 d-flex flex-column p-3">
      <div id="chatbox" class="mb-2">Bitte Chat auswählen.</div>
      <form id="chatForm" class="input-group" style="display:none;">
        <input type="hidden" name="sender" value="Admin">
        <input type="hidden" name="session_id" id="session_id">
        <input type="text" name="message" id="message" class="form-control" placeholder="Nachricht...">
        <button class="btn btn-success" type="submit">Senden</button>
      </form>
      <button id="clearChat" class="btn btn-outline-danger btn-sm mt-2" style="display:none;">🗑️ Chatverlauf löschen</button>
    </div>
  </div>
</div>

<script>
const chatSound = new Audio('/livechat/chat.mp3');
chatSound.volume = 1.0;
let soundEnabled = false;
let notifyEnabled = false;
let currentSession = null;
let lastMessageCount = 0;
let lastMessages = {}; // <- Speichert letzte Nachricht pro Session

// === Aktivierungsleiste anzeigen ===
if (!localStorage.notificationsAllowed) {
  document.getElementById('soundBar').style.display = 'block';
}

// === Notifications aktivieren ===
async function enableNotifications() {
  try {
    const perm = await Notification.requestPermission();
    if (perm === "granted") {
      notifyEnabled = true;
      localStorage.notificationsAllowed = "true";
    }
    chatSound.play().then(() => {
      chatSound.pause();
      chatSound.currentTime = 0;
      soundEnabled = true;
    }).catch(()=>{});
    document.getElementById('soundBar').style.display = 'none';
    console.log("🔔 Benachrichtigungen & Sound aktiviert");
  } catch (e) {
    console.error("Benachrichtigung-Fehler:", e);
  }
}

if (localStorage.notificationsAllowed === "true") {
  notifyEnabled = true;
  soundEnabled = true;
}

// === Sitzungen laden ===
async function loadSessions() {
  const res = await fetch('chat_backend.php?action=sessions');
  const sessions = await res.json();
  let html = '';
  sessions.forEach(s => {
    html += `<div class="session-item" onclick="selectSession('${s.session_id}')">${s.session_id}</div>`;
  });
  document.getElementById('sessionList').innerHTML = html;
  monitorAllChats(sessions);
}

// === Alle Chats überwachen ===
async function monitorAllChats(sessions) {
  for (const s of sessions) {
    try {
      const res = await fetch(`chat_backend.php?action=get&session_id=${s.session_id}`);
      const msgs = await res.json();
      if (msgs.length === 0) continue;
      const lastMsg = msgs[msgs.length - 1];

      // Nur reagieren, wenn neue Gastnachricht
      if (lastMsg.sender === "Gast" && lastMessages[s.session_id] !== lastMsg.message) {
        lastMessages[s.session_id] = lastMsg.message;

        // 🔔 Desktop-Benachrichtigung
        if (notifyEnabled) {
          new Notification("💬 Neuer Chat", {
            body: `Gast: ${lastMsg.message}`,
            icon: "/livechat/chat_icon.png"
          });
        }
        // 🔈 Sound
        if (soundEnabled) chatSound.play().catch(()=>{});
      }
    } catch (e) {
      console.warn("Fehler bei Chatüberwachung:", e);
    }
  }
}

// === Session auswählen ===
async function selectSession(id) {
  currentSession = id;
  document.getElementById('session_id').value = id;
  document.getElementById('chatForm').style.display = 'flex';
  document.getElementById('clearChat').style.display = 'inline-block';
  document.querySelectorAll('.session-item').forEach(el => el.classList.remove('active'));
  document.querySelectorAll('.session-item').forEach(el => {
    if (el.textContent === id) el.classList.add('active');
  });
  lastMessageCount = 0;
  loadChat();
}

// === Chat laden ===
async function loadChat() {
  if (!currentSession) return;
  const res = await fetch(`chat_backend.php?action=get&session_id=${currentSession}`);
  const msgs = await res.json();
  lastMessageCount = msgs.length;
  let html = '';
  msgs.forEach(m => {
    const t = new Date(m.timestamp).toLocaleTimeString('de-DE', {hour:'2-digit',minute:'2-digit'});
    html += `<p><b>${m.sender}:</b> ${m.message} <small class="text-muted">${t}</small></p>`;
  });
  document.getElementById('chatbox').innerHTML = html;
  document.getElementById('chatbox').scrollTop = 999999;
}

// === Nachricht senden ===
document.getElementById('chatForm').onsubmit = async (e) => {
  e.preventDefault();
  const form = new FormData(e.target);
  await fetch('chat_backend.php?action=send', { method:'POST', body:form });
  e.target.message.value = '';
  loadChat();
};

// === Chat löschen ===
document.getElementById('clearChat').onclick = async () => {
  if (!currentSession) return;
  if (!confirm('Diesen Chatverlauf wirklich löschen?')) return;
  const form = new FormData();
  form.append('session_id', currentSession);
  await fetch('chat_backend.php?action=clear', { method:'POST', body:form });
  loadChat();
};

// === Aktualisierung ===
setInterval(() => { loadSessions(); if (currentSession) loadChat(); }, 4000);
loadSessions();
</script>
</body>
</html>
