<?php
session_start();
require_once __DIR__ . '/../config.php';
// 🔹 Zentrale DB-Verbindung laden
require_once __DIR__ . '/../config.php';

$message = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $newUser = trim($_POST['username']);
    $newPass = trim($_POST['password']);
    $confirm = trim($_POST['confirm']);

    if ($newPass !== $confirm) {
        $message = "❌ Die Passwörter stimmen nicht überein.";
    } elseif (strlen($newUser) < 3 || strlen($newPass) < 4) {
        $message = "❌ Benutzername oder Passwort zu kurz.";
    } else {
        try {
            // Prüfen, ob es bereits einen Benutzer gibt
            $check = $db->query("SELECT COUNT(*) FROM users")->fetchColumn();

            // Neues Passwort hashen
            $hash = password_hash($newPass, PASSWORD_DEFAULT);

            if ($check > 0) {
                // 🔹 vorhandenen Benutzer aktualisieren
                $stmt = $db->prepare("UPDATE users SET username = :u, password = :p");
            } else {
                // 🔹 neuen Benutzer anlegen, falls Tabelle leer
                $stmt = $db->prepare("INSERT INTO users (username, password) VALUES (:u, :p)");
            }

            $stmt->execute([':u' => $newUser, ':p' => $hash]);
            $message = "✅ Änderungen erfolgreich gespeichert. Bitte neu einloggen.";

            // 🔹 Sitzung beenden, um neue Daten zu aktivieren
            session_destroy();
            header("Refresh:3; url=login.php");

        } catch (Exception $e) {
            $message = "❌ Fehler beim Speichern: " . $e->getMessage();
        }
    }
}
?>

<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1">
<title>Admin ändern</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background: #f9f9f9; }
.card { border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
</style>
</head>
<body class="p-4">

<div class="container" style="max-width: 500px;">
    <div class="card p-4">
        <h3 class="mb-3 text-center">🔐 Admin-Daten ändern</h3>

        <?php if ($message): ?>
          <div class="alert alert-info text-center"><?= htmlspecialchars($message) ?></div>
        <?php endif; ?>

        <form method="post">
            <div class="mb-3">
                <label for="username" class="form-label">Neuer Benutzername</label>
                <input type="text" name="username" id="username" class="form-control" required>
            </div>

            <div class="mb-3">
                <label for="password" class="form-label">Neues Passwort</label>
                <input type="password" name="password" id="password" class="form-control" required>
            </div>

            <div class="mb-3">
                <label for="confirm" class="form-label">Passwort bestätigen</label>
                <input type="password" name="confirm" id="confirm" class="form-control" required>
            </div>

            <button type="submit" class="btn btn-primary w-100">Speichern</button>
            <a href="dashboard.php" class="btn btn-secondary w-100 mt-2">Zurück</a>
        </form>
    </div>
</div>

</body>
</html>
