<?php
declare(strict_types=1);
require_once __DIR__ . '/../inc/auth.php';
require_once __DIR__ . '/../inc/helpers.php';
require_admin();

$pdo = db();
$posts = $pdo->query("SELECT id,title,status,published_at,updated_at FROM posts ORDER BY updated_at DESC LIMIT 50")->fetchAll();
?>
<!doctype html>
<html lang="de">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Dashboard</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
  <div class="container-fluid">
    <span class="navbar-brand mb-0 h1">Mobiblog Dashboard</span>
    <div class="d-flex">
      <span class="navbar-text text-white me-3">
        Eingeloggt als <strong><?= e($_SESSION['admin_user'] ?? '') ?></strong>
      </span>
    </div>
  </div>
</nav>

<div class="container mt-4">
  <div class="d-flex justify-content-between align-items-center mb-4">
    <h2>Beiträge verwalten</h2>
    <div>
      <a href="<?= e(BASE_PATH) ?>admin/post_edit.php" class="btn btn-success">
        <i class="bi bi-plus-circle"></i> Neuer Beitrag
      </a>
      <a href="<?= e(BASE_PATH) ?>admin/logout.php" class="btn btn-outline-danger">Logout</a>
    </div>
  </div>

  <div class="card shadow-sm">
    <div class="card-body p-0">
      <div class="table-responsive">
        <table class="table table-hover mb-0">
          <thead class="table-light">
            <tr>
              <th>ID</th>
              <th>Titel</th>
              <th>Status</th>
              <th>Aktualisiert</th>
              <th class="text-end">Aktionen</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($posts as $p): ?>
              <tr>
                <td><?= (int)$p['id'] ?></td>
                <td><?= e($p['title']) ?></td>
                <td>
                  <?php if ($p['status'] === 'published'): ?>
                    <span class="badge bg-success">Published</span>
                  <?php else: ?>
                    <span class="badge bg-secondary"><?= e($p['status']) ?></span>
                  <?php endif; ?>
                </td>
                <td><?= date('d.m.Y H:i', (int)$p['updated_at']) ?></td>
                <td class="text-end">
                  <a href="<?= e(BASE_PATH) ?>admin/post_edit.php?id=<?= (int)$p['id'] ?>" 
                     class="btn btn-sm btn-primary">Bearbeiten</a>
                  <a href="<?= e(BASE_PATH) ?>admin/post_delete.php?id=<?= (int)$p['id'] ?>" 
                     class="btn btn-sm btn-danger"
                     onclick="return confirm('Wirklich löschen?')">Löschen</a>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>