<?php
declare(strict_types=1);
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';

function admin_session_start(): void {
  if (session_status() === PHP_SESSION_NONE) {
    session_name(SESSION_NAME);
    session_start();
  }
}

function is_admin(): bool {
  admin_session_start();
  return !empty($_SESSION['admin_id']);
}

function require_admin(): void {
  if (!is_admin()) {
    header('Location: ' . BASE_PATH . 'admin/login.php');
    exit;
  }
}

function admin_login(string $user, string $pass): bool {
  $pdo = db();
  $st = $pdo->prepare("SELECT id, username, pass_hash FROM users WHERE username = :u LIMIT 1");
  $st->execute([':u' => $user]);
  $row = $st->fetch();
  if (!$row) return false;
  if (!password_verify($pass, $row['pass_hash'])) return false;

  admin_session_start();
  $_SESSION['admin_id'] = (int)$row['id'];
  $_SESSION['admin_user'] = $row['username'];
  return true;
}

function admin_logout(): void {
  admin_session_start();
  $_SESSION = [];
  session_destroy();
}
