<?php
declare(strict_types=1);

function db(): PDO {
  static $pdo = null;
  if ($pdo) return $pdo;

  if (!defined('SQLITE_PATH')) {
    // Installer noch nicht gelaufen
    throw new RuntimeException('Mobiblog ist noch nicht installiert (config.local.php fehlt).');
  }

  $pdo = new PDO('sqlite:' . SQLITE_PATH, null, null, [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
  ]);

  // Für bessere Parallelität
  $pdo->exec("PRAGMA journal_mode = WAL;");
  $pdo->exec("PRAGMA foreign_keys = ON;");

  return $pdo;
}
