<?php
declare(strict_types=1);
require_once __DIR__ . '/inc/config.php';
require_once __DIR__ . '/inc/db.php';
require_once __DIR__ . '/inc/helpers.php';

$pdo = db();
$posts = $pdo->query("SELECT title, slug, content, published_at FROM posts
                      WHERE status='published'
                      ORDER BY published_at DESC
                      LIMIT 20")->fetchAll();
?>
<!doctype html>
<html lang="de"><head><meta charset="utf-8"><title><?= e(APP_NAME) ?></title></head>
<body style="font-family:Arial; padding:20px">
<h1><?= e(APP_NAME) ?></h1>

<?php foreach ($posts as $p): ?>
  <article style="margin-bottom:25px">
    <h2>
      <a href="<?= e(BASE_PATH) ?>post.php?slug=<?= e($p['slug']) ?>"><?= e($p['title']) ?></a>
    </h2>
    <div style="color:#666"><?= date('d.m.Y', (int)$p['published_at']) ?></div>
  </article>
<?php endforeach; ?>

</body></html>
