<?php
declare(strict_types=1);
require_once __DIR__ . '/../inc/auth.php';

admin_session_start();
if (is_admin()) {
  header('Location: ' . BASE_PATH . 'admin/dashboard.php');
  exit;
}

$err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $u = trim($_POST['user'] ?? '');
  $p = trim($_POST['pass'] ?? '');
  try {
    if (admin_login($u, $p)) {
      header('Location: ' . BASE_PATH . 'admin/dashboard.php');
      exit;
    }
    $err = 'Login fehlgeschlagen.';
  } catch (Throwable $e) {
    $err = $e->getMessage();
  }
}
?>
<!doctype html>
<html lang="de">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Admin Login</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
  body {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    min-height: 100vh;
    display: flex;
    align-items: center;
  }
  .login-card {
    max-width: 400px;
    margin: 0 auto;
  }
</style>
</head>
<body>
<div class="container">
  <div class="login-card">
    <div class="card shadow-lg">
      <div class="card-body p-5">
        <div class="text-center mb-4">
          <h2 class="card-title">Mobiblog Admin</h2>
          <p class="text-muted">Bitte melden Sie sich an</p>
        </div>

        <?php if ($err): ?>
          <div class="alert alert-danger" role="alert">
            <?= htmlspecialchars($err) ?>
          </div>
        <?php endif; ?>

        <form method="post">
          <div class="mb-3">
            <label for="user" class="form-label">Benutzer</label>
            <input type="text" 
                   class="form-control" 
                   id="user" 
                   name="user" 
                   placeholder="Benutzername" 
                   required 
                   autofocus>
          </div>

          <div class="mb-4">
            <label for="pass" class="form-label">Passwort</label>
            <input type="password" 
                   class="form-control" 
                   id="pass" 
                   name="pass" 
                   placeholder="Passwort" 
                   required>
          </div>

          <div class="d-grid">
            <button type="submit" class="btn btn-primary btn-lg">Login</button>
          </div>
        </form>

        <hr class="my-4">

        <div class="text-center">
          <a href="<?= htmlspecialchars(BASE_PATH) ?>install/index.php" class="text-decoration-none">
            Zur Installation
          </a>
        </div>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>