<?php
require_once '../config.php';
if (!isset($_SESSION["connecte"])) {
    header("Location: index.php");
    exit;
}

$message = "";
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $titre = $_POST["titre"] ?? '';
    $texte = $_POST["text"] ?? '';
    $imageName = '';

    if (!empty($_FILES["bild"]["name"])) {
        $allowed = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
        $targetDir = "../uploads/";
        $extension = strtolower(pathinfo($_FILES["bild"]["name"], PATHINFO_EXTENSION));

        if (in_array($extension, $allowed)) {
            $imageName = uniqid("news_") . "." . $extension;
            $targetPath = $targetDir . $imageName;
            move_uploaded_file($_FILES["bild"]["tmp_name"], $targetPath);
        } else {
            $message = "Bildformat nicht zulässig.";
        }
    }

    if (empty($message)) {
        $stmt = $conn->prepare("INSERT INTO news (titel, text, bild, datum) VALUES (?, ?, ?, NOW())");
        $stmt->execute([$titre, $texte, $imageName]);
        $message = "Neuigkeiten erfolgreich hinzugefügt.";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Neuigkeit hinzufügen</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="../js/tinymce/tinymce.min.js"></script>
    <script>
        tinymce.init({
            selector: 'textarea.tinymce',
            height: 300,
            menubar: false,
            plugins: 'link image code lists emoticons textcolor',
            toolbar: 'undo redo  | fontfamily | styleselect fontselect | fontsizeinput | fontsizeselect bold italic underline | emoticons | alignleft aligncenter alignright | bullist numlist | forecolor backcolor | link image | code' ,
            language: 'en',
		    relative_urls: false,
            remove_script_host: false
			
	
        });
    </script>
</head>
<body class="bg-light">
<div class="container mt-4">
    <h2>Neuigkeit hinzufügen</h2>
    <?php if ($message): ?>
        <div class="alert alert-info" id="successMessage"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>
   



    <form method="post" enctype="multipart/form-data">
    <div class="mb-3">
        <label>Titel</label>
        <input type="text" name="titre" class="form-control" required>
    </div>
    <div class="mb-3">
        <label>Titel Farbe</label>
        <input type="color" name="titel_farbe" class="form-control form-control-color" value="#000000" title="Wähle eine Farbe">
    </div>
    <div class="mb-3">
        <label>Text</label>
        <textarea name="text" class="form-control tinymce"></textarea>
    </div>
    <div class="mb-3">
        <label>Bild (optional)</label>
        <input type="file" name="bild" class="form-control">
    </div>
    <button class="btn btn-primary">Speichern</button>
    <a href="dashboard.php" class="btn btn-secondary">Zurück</a>
</form>

</div>
</body>
<script>
    setTimeout(() => {
        document.getElementById("successMessage")?.remove();
    }, 3000);
</script>
</html>
