<?php
// Autor: Volker Niederastroth 2025
require_once 'config.php';
$token = $_GET['token'] ?? '';
if ($token === '') exit('Ungültiger Link.');

$db = db_connect();
$stmt = $db->prepare("SELECT * FROM downloads WHERE token=? AND benutzt=0");
$stmt->execute([$token]);
$entry = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$entry) exit('Ungültig oder bereits verwendet.');
if (strtotime($entry['abgelaufen_am']) < time()) exit('Link abgelaufen.');

$filename = $entry['dateiname'];
// absoluten Pfad zusammenbauen
$base = realpath(DOWNLOAD_PATH);
$filePath = realpath($base . DIRECTORY_SEPARATOR . $filename);

// prüfen, ob realpath erfolgreich und Datei innerhalb des download-Ordners liegt
if ($filePath === false || strpos($filePath, $base) !== 0 || !is_file($filePath)) {
    exit('Datei nicht gefunden oder Zugriff nicht erlaubt.');
}

// optional: Dateigröße prüfen, Header senden und streamen
header('Content-Description: File Transfer');
header('Content-Type: application/octet-stream');
header('Content-Disposition: attachment; filename="' . basename($filePath) . '"');
header('Content-Length: ' . filesize($filePath));
flush();
$fp = fopen($filePath, 'rb');
while (!feof($fp)) {
    echo fread($fp, 8192);
    flush();
}
fclose($fp);

// als benutzt markieren
$stmt = $db->prepare("UPDATE downloads SET benutzt=1 WHERE id=?");
$stmt->execute([$entry['id']]);
exit;
?>
