<?php
// auth.php – DOMAINWEITE SESSION (FIX!)

if (session_status() !== PHP_SESSION_ACTIVE) {

    session_set_cookie_params([
        'path'     => '/',        // 🔥 WICHTIG: ganze Domain
        'httponly' => true,
        'samesite' => 'Lax'
    ]);

    session_start();
}

function db(): PDO {
    static $db;
    if (!$db) {
        $cfg = require __DIR__ . '/config.php';
        $db = new PDO('sqlite:' . $cfg['DB']);
        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    }
    return $db;
}

function is_admin(): bool {
    return !empty($_SESSION['admin']);
}
