<?php
// Neutrale Startseite des CMS
$config = require __DIR__ . '/config.php';
?>
<!doctype html>
<html lang="de">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>PHP Mini CMS</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body class="bg-light">
<div class="container my-5">

  <div class="card shadow-sm p-4">
    <h2 class="mb-3">PHP Mini CMS 2025 Volker Niederastroth</h2>

    <p class="text-muted">
      Dieses Verzeichnis enthält das Content-Management-System.
      Inhalte werden <strong>nicht hier</strong>, sondern in deinen Webseiten eingebunden.
    </p>

    <hr>

    <h5>🔐 Verwaltung</h5>
    <ul>
      <li>
        <a href="<?= htmlspecialchars($config['BASE_URL']) ?>/login.php">Login</a>
      </li>
      <li>
        <a href="<?= htmlspecialchars($config['BASE_URL']) ?>/admin/dashboard.php">Dashboard</a>
      </li>
    </ul>

    <hr>

    <h5>📌 Inhalte einbinden</h5>
    <p>
      Um Inhalte in einer Webseite (z. B. Mobirise oder PHP-Seite) anzuzeigen,
      füge dort einen HTML-/Code-Block ein und verwende:
    </p>

<pre class="bg-light border p-3"><code>&lt;?php
$slug = 'start';
include $_SERVER['DOCUMENT_ROOT'] . '<?= htmlspecialchars($config['BASE_URL']) ?>/cms.php';
?&gt;</code></pre>

    <p class="small text-muted">
      Ersetze <code>start</code> durch den gewünschten Slug.
    </p>

    <hr>

    <h5>✏️ Inline bearbeiten</h5>
    <p>
      Als Admin kannst du Inhalte direkt auf der Webseite bearbeiten:
    </p>
    <pre class="bg-light border p-3"><code>?edit=1</code></pre>

    <p class="small text-muted mb-0">
      Beispiel: <code>https://deinedomain.de/seite.php?edit=1</code>
    </p>
  </div>

</div>
</body>
</html>
