<?php
// ====================
// TOKEN ERSTELLEN
// ====================
$storageFile = __DIR__ . "/tokens.json";
$protectedDir = __DIR__ . "/schutz"; 
$validHours = 24;   // Gültigkeit in Stunden

// Dateien/Ordner auswählen
// Beispiel: Einzelne Dateien
$files = ["test.zip", "bericht.pdf"];

// Beispiel: Ganzer Ordner
// $files = array_diff(scandir($protectedDir), ['.', '..']);

// Tokens laden
$tokens = file_exists($storageFile) ? json_decode(file_get_contents($storageFile), true) : [];

// Token erzeugen
$token = bin2hex(random_bytes(16));
$expires = time() + ($validHours * 3600);

$tokens[$token] = [
    "files" => $files,
    "expires" => $expires
];

// Tokens speichern
file_put_contents($storageFile, json_encode($tokens));

// Link ausgeben
$link = "https://deinserver.de/download.php?token=" . $token;
echo "✅ Token erstellt: <a href='$link'>$link</a> (gültig bis " . date("d.m.Y H:i", $expires) . ")";
