<?php
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['role'] !== "admin") {
    header("Location: login.php");
    exit;
}

$users = json_decode(file_get_contents("users.json"), true);
?><!DOCTYPE html>
<html  >
<head>
  
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  
  <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1">
  <link rel="shortcut icon" href="assets/images/logo.png" type="image/x-icon">
  <meta name="description" content="">
  
  
  <title>user admin</title>
  <link rel="stylesheet" href="assets/bootstrap/css/bootstrap.min.css">
  <link rel="stylesheet" href="assets/popup-overlay-plugin/style.css">
  <link rel="stylesheet" href="assets/dropdown/css/style.css">
  <link rel="stylesheet" href="assets/socicon/css/styles.css">
  <link rel="stylesheet" href="assets/theme/css/style.css">
  <link rel="preload" href="https://fonts.googleapis.com/css2?family=Jost:ital,wght@0,400;0,700;1,400;1,700&display=swap&display=swap" as="style" onload="this.onload=null;this.rel='stylesheet'">
  <noscript><link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Jost:ital,wght@0,400;0,700;1,400;1,700&display=swap&display=swap"></noscript>
  <link rel="preload" as="style" href="assets/mobirise/css/mbr-additional.css?v=FADM3d"><link rel="stylesheet" href="assets/mobirise/css/mbr-additional.css?v=FADM3d" type="text/css">

  
  
  

</head>
<body>
  
  <section data-bs-version="5.1" class="menu menu2 cid-v47LWkalf8" once="menu" id="menu2-4">
    
    <nav class="navbar navbar-dropdown navbar-fixed-top navbar-expand-lg">
        <div class="container">
            <div class="navbar-brand">
                <span class="navbar-logo">
                    <a href="#">
                        <img src="assets/images/logo.png" alt="" style="height: 3rem;">
                    </a>
                </span>
                <span class="navbar-caption-wrap"><a class="navbar-caption text-black display-7" href="#">Mobirise</a></span>
            </div>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-bs-toggle="collapse" data-target="#navbarSupportedContent" data-bs-target="#navbarSupportedContent" aria-controls="navbarNavAltMarkup" aria-expanded="false" aria-label="Toggle navigation">
                <div class="hamburger">
                    <span></span>
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
            </button>
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav nav-dropdown nav-right" data-app-modern-menu="true"><li class="nav-item"><a class="nav-link link text-black text-primary display-4" href="user_admin.php">Verwaltung</a></li>
                    <li class="nav-item"><a class="nav-link link text-black display-4" href="#">
                            Services</a></li>
                    <li class="nav-item"><a class="nav-link link text-black text-primary display-4" href="logout.php">Logout</a>
                    </li></ul>
                
                
            </div>
        </div>
    </nav>
</section>

<section data-bs-version="5.1" class="content5 cid-v47LWkvIct" id="content5-5">
    
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12 col-lg-10">
                
                <h4 class="mbr-section-subtitle mbr-fonts-style mb-4 display-5">
                    Benutzerverwaltung</h4>
                <p class="mbr-text mbr-fonts-style display-7"></p>
            </div>


<?php
echo '<table class="table table-striped table-bordered">';
echo '<thead><tr><th>Benutzername</th><th>Rolle</th><th>Aktionen</th></tr></thead>';
echo '<tbody>';

foreach ($users as $u) {

    $username = htmlspecialchars($u["username"]);
    $role = htmlspecialchars($u["role"]);
    $link_edit = "user_edit.php?u=" . urlencode($u['username']);
    $link_delete = "user_delete.php?u=" . urlencode($u['username']);

    echo "<tr>";
    echo "<td>$username</td>";
    echo "<td>$role</td>";
    echo "<td>";

   echo "<a href='$link_edit' class='btn btn-sm btn-primary me-2'>Passwort ändern</a>";

$link_edit_full = "user_edit_full.php?u=" . urlencode($u['username']);
echo "<a href='$link_edit_full' class='btn btn-sm btn-warning me-2'>Ändern</a>";

    if ($u['username'] !== "admin") {
        echo " <a href='$link_delete' class='btn btn-sm btn-danger' onclick='return confirm(\"Löschen?\");'>Löschen</a>";
    }

    echo "</td>";
    echo "</tr>";
}

echo '</tbody></table>';
?>

<hr>

<h4>Neuen Benutzer hinzufügen</h4>

<form action="user_save.php" method="post">

    <div class="mb-3">
        <label class="form-label">Benutzername:</label>
        <input type="text" name="username" class="form-control" required="">
    </div>

    <div class="mb-3">
        <label class="form-label">Passwort:</label>
        <input type="password" name="password" class="form-control" required="">
    </div>

    <div class="mb-3">
        <label class="form-label">Rolle:</label>
        <select name="role" class="form-select">
            <option value="user">User</option>
            <option value="admin">Admin</option>
        </select>
    </div>

    <button type="submit" class="btn btn-success">Speichern</button>
</form>

<p class="mt-3"><a href="secure_page.php" class="btn btn-secondary">Zurück</a></p>
        </div>
    </div>
</section>


<script src="assets/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="assets/smoothscroll/smooth-scroll.js"></script>
  <script src="assets/ytplayer/index.js"></script>
  <script src="assets/dropdown/js/navbar-dropdown.js"></script>
  <script src="assets/theme/js/script.js"></script>
  
  
  

</body>
</html>