<?php
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['role'] !== "admin") {
    header("Location: login.php");
    exit;
}

$users = json_decode(file_get_contents("users.json"), true);

$oldUser = $_GET['u'] ?? null;
$found = null;

foreach ($users as $u) {
    if ($u["username"] === $oldUser) {
        $found = $u;
        break;
    }
}

if (!$found) {
    die("Benutzer nicht gefunden!");
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {

    $newName = $_POST["username"];
    $newRole = $_POST["role"];
    $newPassword = $_POST["password"];

    foreach ($users as &$u) {
        if ($u["username"] === $oldUser) {

            // Username & Rolle ändern
            $u["username"] = $newName;
            $u["role"] = $newRole;

            // Passwort ändern, wenn eingegeben
            if (!empty($newPassword)) {
                $salt = substr(str_shuffle("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"), 0, 10);
                $u["salt"] = $salt;
                $u["password"] = hash("sha256", $newPassword . $salt);
            }
        }
    }

    file_put_contents("users.json", json_encode($users, JSON_PRETTY_PRINT));

    header("Location: user_admin.php");
    exit;
}

?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Benutzer bearbeiten</title>
<link rel="stylesheet" href="assets/bootstrap/css/bootstrap.min.css">
</head>
<body class="p-4">

<div class="container">
    <h3>Benutzer bearbeiten</h3>

    <form method="post">

        <div class="mb-3">
            <label class="form-label">Benutzername</label>
            <input type="text" name="username" class="form-control" value="<?= htmlspecialchars($found['username']); ?>" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Rolle</label>
            <select name="role" class="form-select">
                <option value="user" <?= $found['role'] === 'user' ? 'selected' : '' ?>>User</option>
                <option value="admin" <?= $found['role'] === 'admin' ? 'selected' : '' ?>>Admin</option>
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Neues Passwort (optional)</label>
            <input type="password" name="password" class="form-control">
            <small class="text-muted">Leer lassen = Passwort bleibt unverändert</small>
        </div>

        <button type="submit" class="btn btn-primary">Speichern</button>
        <a href="user_admin.php" class="btn btn-secondary ms-2">Abbrechen</a>
    </form>
</div>

</body>
</html>
